<?php
/**
 * Super-old numerology code. TODO: replace with the more modern version, this was the first version I stumbled across.
 */

class Calculator_Numerology {
    
    private static $_masterNumbers = array(11, 22);
    private static $_vowels = array('a', 'e', 'i', 'o', 'u');
    
    /**
     * Reduce a Number following Numerology Principles
     *
     * Options Array
     *      stopOnMasterNumber, Return when we reach a Master Number, Default: TRUE
     *      numberOnly, Return just the number, not the workings, Default: FALSE
     * 
     * Result Array
     *      original    => The original number passed into the function
     *      number      => The end result
     *      lines       => Array of calculations including:
     *          result      => single number result for the calculation
     *          equation    => the equation used to calculate the result
     *          explanation => an explanation of the equation
     * 
     * @param Integer $number
     * @param Array $options
     * @return Array
     */
    public static function reduce($number, $options = array()) {

        // Intialize Options, Set Stop on Master to True if not explicitly set to false
        $options['stopOnMasterNumber'] = (isset($options['stopOnMasterNumber']) && ($options['stopOnMasterNumber'] == false) ? false : true);
        $options['numberOnly'] = true;
        
        // Intialize Result
        $resultObj = array('original' => intval($number), 'number' => intval($number), 'lines' => array());
        
        do {
            
            $result = 0;
            $equation = '';
            
            if ($options['stopOnMasterNumber'] && in_array($resultObj['number'], self::$_masterNumbers)) {
                
                $explanation = 'Note that we do not add the two digits <span class="calculation-result">' . $resultObj['number'] . '</span> because <span class="calculation-result">' . $resultObj['number'] . '</span> is known as a Master Number';
                
            } else if ($resultObj['number'] <= 9) {
                
                $explanation = 'As <span class="calculation-result">' . $resultObj['number'] . "</span> is a single digit, there's nothing to add here.";
            
            } else {
            
                $strNumber = strval($resultObj['number']);
                
                for ($i = 0; $i < strlen($strNumber); $i++) {
                    $digit = intval(substr($strNumber, $i, 1));
                    $result += $digit;
                    $equation .= $digit . ' + ';
                }
                // Remove trailing ' + '
                $equation = substr($equation, 0, strlen($equation) - 2);
                
                $explanation = 'Adding ' . $equation . ' gives us <span class="calculation-result">' . $result . '</span>';
                $equation = $equation . '= ' . $result;
                
                // Update the Result Object Number
                $resultObj['number'] = $result;
            
            }
                        
            $resultObj['lines'][] = array('result' => $result, 'equation' => $equation, 'explanation' => $explanation);

        } while ( !($resultObj['number'] <= 9) && !($options['stopOnMasterNumber'] && in_array($resultObj['number'], self::$_masterNumbers)) );
        
        if ($options['numberOnly']) return $resultObj['number'];
        
        return $resultObj;
    }
    
    public static function letterValue($letter) {
        $result = ((ord(strtolower($letter)) - 96) % 9);
        $result = ($result > 0 ? $result : 9);
        return $result;
    }

    public static function letterRow($letter) {
        return floor(((ord(strtolower($letter)) - 96) / 9));
    }

    public static function isVowel( $name, $pos )
    {
        $name = str_split($name);
        $c = strtolower( $name[ $pos ] );

        // A: If it's a standard vowel
        if( in_array($c, self::$_vowels) ) return true;

        // B: If it's not a Y
        if( $c != 'y') return false;

        // Y: If it's a Y and the only Letter
        if( count($name) == 1) return true;

        // YA: If Y is the First Letter followed by a vowel
        if( ($pos == 0) && in_array($name[ $pos + 1 ], self::$_vowels) ) return false;

        // YB: If Y is the First Letter followed by a consonant
        if( ($pos == 0) && !in_array($name[ $pos + 1 ], self::$_vowels) ) return true;

        // AY: If Y is the Last Letter preceded by a vowel
        if( ($pos == count($name)-1) && in_array($name[ $pos - 1 ], self::$_vowels) ) return false;

        // BY: If Y is the Last Letter preceded by a consonant
        if( ($pos == count($name)-1) && !in_array($name[ $pos - 1 ], self::$_vowels) ) return true;

        // AYA: If Y in between Two Vowels it's a consonant
        if ( in_array($name[ $pos - 1 ], self::$_vowels) && in_array($name[ $pos + 1 ], self::$_vowels) ) return false;

        // BYA: If Y is in between a Consonant and a Vowel it's a Vowel
        if ( !in_array($name[ $pos - 1 ], self::$_vowels) && in_array($name[ $pos + 1 ], self::$_vowels) )
        {
            if ($name[ $pos + 1 ] == 'a') 
                return true;
            else
                return false;
        }

        // AYB: If Y is in between a Vowel and a Consonant it's a Vowel
        if ( in_array($name[ $pos - 1 ], self::$_vowels) && !in_array($name[ $pos + 1 ], self::$_vowels) ) return false;

        // BYB: If Y is in between a Consonant and a Consonant it's a Vowel
        if ( !in_array($name[ $pos - 1 ], self::$_vowels) && !in_array($name[ $pos + 1 ], self::$_vowels) ) return true;
        
        // This should never happen....
        return true;
    }

    public static function getBridge($number1, $number2) {
        $result = array('number' => 0, 'explanation' => '');

        $number1 = self::reduce($number1, false);
        $number2 = self::reduce($number2, false);

        $result['number'] = ($number1 > $number2 ? $number1 - $number2 : $number2 - $number1);

        return $result;
    }

    public static function getSumOfLetters($name, $vowels = true, $consonants = true) {
        $nameArray = explode(' ', $name);

        $result = array('number' => 0, 'total' => 0);
        foreach ($nameArray as $namePart) {
            for ($i = 1; $i <= strlen($namePart); $i++) {
                if ( $vowels && self::isVowel($namePart, $i-1) ) $result['total'] += self::letterValue(substr($namePart, ($i-1), 1));
                else if ( $consonants && !self::isVowel($namePart, $i-1) ) $result['total'] += self::letterValue(substr($namePart, ($i-1), 1));
            }
        }

        $result['number'] = self::reduce($result['total']);

        return $result;
    }

    public static function getSumOfLettersChart($name, $vowels = true, $consonants = true) {
        $nameArray = split(' ', $name);

        $result = array();
        foreach ($nameArray as $namePart) {
            for ($i = 1; $i <= strlen($namePart); $i++) {
                $result['workings'][1][] = substr($namePart, ($i-1), 1);

                if ( $vowels && self::isVowel($namePart, $i-1) ) {
                    $result['number'] += self::letterValue(substr($namePart, ($i-1), 1));
                    $result['workings'][2][] = '';
                    $result['workings'][0][] = self::letterValue(substr($namePart, ($i-1), 1));
                }
                else if ( $consonants && !self::isVowel($namePart, $i-1) ) {
                    $result['number'] += self::letterValue(substr($namePart, ($i-1), 1));
                    $result['workings'][0][] = '';
                    $result['workings'][2][] = self::letterValue(substr($namePart, ($i-1), 1));
                } else {
                    $result['workings'][0][] = '';
                    $result['workings'][2][] = '';
                }

            }
            $result['workings'][0][] = '';
            $result['workings'][1][] = '';
            $result['workings'][2][] = '';
        }

        asort($result['workings']);

        $result['number'] = self::reduce($result['number']);

        return $result;
    }

    public static function getLifePathNumber($year, $month, $day) {
        /*
         * Result Data Structure
         * 
         * number       - the actual life path number
         * workings
         *      day         - the day number reduced down   
         *      month       - the month number reduced down
         *      year        - the year number reduced down
         *      life_path_number    - the life path number
         * description  - the description of life path
         * 
         * chart
         *      day
         *          workings[]  - each element is a step closer to what the day number reduces down to
         *      month
         *          workings[]  - each element is a step closer to what the month number reduces down to
         *      year
         *          workings[]  - each element is a step closer to what the year number reduces down to
         *      bridge
         *          number      - if the year, month, day do not reduce down cleanly we use this bridge number as an interim point
         */
        
        

   //     list($year,$month,$day) = split('-', $dob);

        $lifepath = self::reduce(self::reduce($month) + self::reduce($day) + self::reduce($year) );

        return $lifepath;
    }
    
    public static function getLifePathChart($dob, $relPath = './', $display = true, $coupon = '') {
    
        $details = self::getLifePathNumber($dob);
        
        // Img links /images/chart-left.jpg /images/chart-right.jpg /images/chart-right-nb.jpg
                
        /*
         * Potentially there can be no working columns for the month/day so we need to check for that first, before finding out which is biggest
         */
        $yearCols = (isset($details['chart']['year']['workings']) ? sizeof($details['chart']['year']['workings']) : 0);
        $monthCols = (isset($details['chart']['month']['workings']) ? sizeof($details['chart']['month']['workings']) : 0);
        $dayCols = (isset($details['chart']['day']['workings']) ? sizeof($details['chart']['day']['workings']) : 0);
        
        $cols = max($yearCols, $monthCols, $dayCols);
        
        $html ='<table border="0" cellpadding="0" cellspacing="0"><tr>';
        
        // Month
        for($i = ($cols - sizeof($details['chart']['month']['workings'])); $i > 1; $i--) {
            $html .='<td><img src="/free/images/chart-blank.jpg" /></td>';
        }
        
        // Month Name
        $monthAbbrev = ucwords(date('M', mktime(0,0,0,$details['workings']['month']['number'])));
        $html .='<td><img src="/free/images/chart-parts/month-' . strtolower($monthAbbrev) . '.png" /></td>';
        
        foreach($details['chart']['month']['workings'] as $working) {
            $html .='<td><img src="/free/images/chart-parts/arrow-' . $working . '.png" /></td>';
        }
        
        $html .= '<td><img src="/free/images/chart-parts/rt-' . $details['workings']['month']['number'] . '.png" /></td>';
        $html .= '<td><img src="/free/images/chart-blank.jpg" /></td>';
        $html .= '<td>&nbsp;</td></tr><tr>';
        
        // Day
        for($i = ($cols - sizeof($details['chart']['day']['workings'])); $i > 0; $i--) {
            $yearfont = ($counter == 0 ? 'bold-' : '');
            $html .='<td><img src="/free/images/chart-blank.jpg" /></td>';
        }
        
        $counter = 0;
        foreach($details['chart']['day']['workings'] as $working) {
            $dayfont = ($counter == 0 ? 'bold-' : '');
            $html .='<td><img src="/free/images/chart-parts/arrow-' . $dayfont . $working . '.png" /></td>';
        }
        
        $html .= '<td><img src="/free/images/chart-parts/arrow-' . $details['workings']['day']['number'] . '.png" /></td>';
        
        if($details['chart']['bridge']['number'] === false) {
            $html .= '<td><img src="/free/images/chart-parts/final-' . $details['number'] . '.png" /></td>';
            $html .='<td>&nbsp;</td>';
        } else {
            $html .= '<td><img src="/free/images/chart-parts/bridge-' . $details['chart']['bridge']['number'] . '.png" /></td>';
            $html .= '<td><img src="/free/images/chart-parts/final-' . $details['number'] . '.png" /></td>';
        }
        $html .='</tr><tr>';
        
        // Year
        for($i = ($cols - sizeof($details['chart']['year']['workings'])); $i > 0; $i--) {
            $html .='<td><img src="/free/images/chart-blank.jpg" /></td>';
        }
        
        $counter = 0;
        foreach($details['chart']['year']['workings'] as $working) {
            $yearfont = ($counter == 0 ? 'bold-' : '');
            $html .='<td><img src="/free/images/chart-parts/arrow-' . $yearfont . $working . '.png" /></td>';

            $counter++;
        }
        
        $html .= '<td><img src="/free/images/chart-parts/rb-' . $details['workings']['year']['number'] . '.png" /></td>';
        $html .= '<td><img src="/free/images/chart-blank.jpg" /></td>';
        $html .= '<td>&nbsp;</td></tr>';
                
        $html .='</table>';     
        
        if($display) {
            echo $html;
        } else {
            return $html;
        }
        
    }

    public static function getExpressionNumber($fullname) {

        $result = self::getSumOfLetters($fullname, true, true);
        //$result['workings'] =

        return $result;
    }

    public static function getMinorExpressionNumber($shortname) {
        return self::getSumOfLetters($shortname, true, true);
    }

    public static function getSoulUrgeNumber($fullname) {
        return self::getSumOfLetters($fullname, true, false);
    }

    public static function getMinorSoulUrgeNumber($shortname) {
        return self::getSumOfLetters($shortname, true, false);
    }

    public static function getKarmicNumber($fullname) {
        return self::getSumOfLetters($fullname, false, true);
    }

    public static function getMinorKarmicNumber($shortname) {
        return self::getSumOfLetters($shortname, false, true);
    }

    public static function getMaturityNumber($lifePathNumber, $expressionNumber) {
        $result = array('number' => 0);

        $result['number'] = self::reduce( ($lifePathNumber + $expressionNumber) );
        $result['workings']['maturity_number'] = self::reduceToArray(($lifePathNumber + $expressionNumber));

        return $result;
    }

    public static function getRationalThoughtNumber($firstName, $dayOfBirth) {
        $result = array('number' => 0);

        $sumOfLettersFirstName = self::getSumOfLetters($firstName);

        $result['number'] = self::reduce( ($sumOfLettersFirstName['total'] + $dayOfBirth) );

        return $result;
    }

    public static function getCornerstoneLetter($firstName) {
        $result = array('letter' => '');

        $result['letter'] = strtoupper(substr($firstName, 0, 1));

        return $result;
    }

    public static function getSubconsciousSelfNumber($karmicLessonChart) {
        $result = array('number' => 0);

        $result['number'] = 9 - count($karmicLessonChart['lesson_numbers']);

        return $result;
    }

    public static function getLifeChallengeNumbers($dob) {
        $result = array('numbers' => array());

        list($year,$month,$day) = split('-', $dob);

        $first = self::getBridge(self::reduce($month, false), self::reduce($day, false));
        $second = self::getBridge(self::reduce($day, false), self::reduce($year, false));
        $third = self::getBridge(self::reduce($first['number']), self::reduce($second['number']));
        $fourth = self::getBridge(self::reduce($month, false), self::reduce($year, false));

        $result['numbers'][1] = $first['number'];
        $result['numbers'][2] = $second['number'];
        $result['numbers'][3] = $third['number'];
        $result['numbers'][4] = $fourth['number'];

        return $result;
    }

    public static function getPinnacleNumbers($dob, $lifePathNumber) {
        $result = array('numbers' => array());

        list($year,$month,$day) = split('-', $dob);

        $result['numbers'][1]['number'] = self::reduce(self::reduce($month) + self::reduce($day));
        $result['numbers'][1]['change'] = 36 - $lifePathNumber;

        $result['numbers'][2]['number'] = self::reduce(self::reduce($day) + self::reduce($year));
        $result['numbers'][2]['change'] = $result['numbers'][1]['change'] + 9;

        $result['numbers'][3]['number'] = self::reduce(self::reduce($result['numbers'][1]['number']) + self::reduce($result['numbers'][2]['number']));
        $result['numbers'][3]['change'] = $result['numbers'][2]['change'] + 9;

        $result['numbers'][4]['number'] = self::reduce(self::reduce($month) + self::reduce($year));
        $result['numbers'][4]['change'] = $result['numbers'][3]['change'] + 9;

        return $result;
    }

    public static function getKarmicLessonChart($fullname) {
        $nameArray = split(' ', $fullname);

        $result = array('number' => 0, 'explanation' => '');

        $karmicLessonChart = array();
        for ($j = 1; $j <= 9; $j++)
            $karmicLessonChart[$j] = 0;

        foreach ($nameArray as $name) {
            for ($i = 1; $i <= strlen($name); $i++) {
                $karmicLessonChart[self::letterValue(substr($name, ($i-1), 1))]++;
            }
        }

        foreach ($karmicLessonChart as $number => $tally) {
            if( ($tally == 0) && ($result['number'] == 0)) $result['number'] = $number;
            if( ($tally == 0) && ($result['number'] != 0)) $result['lesson_numbers'][] = $number;
        }

        $result['chart'] = $karmicLessonChart;

        return $result;
    }

    public static function getHiddenPassionChart($karmicLessonChart) {
        $result = array('number' => 0, 'explanation' => '');

        arsort($karmicLessonChart['chart']);

        $highestOccurrence = 0;
        foreach ($karmicLessonChart['chart'] as $number => $tally) {
            if( $tally > $highestOccurrence ) $highestOccurrence = $tally;
            if ( ($tally == $highestOccurrence) && ($result['number'] == 0) ) $result['number'] = $number;
            if ( ($tally == $highestOccurrence) && ($result['number'] != 0) ) $result['passion_numbers'][] = $number;
        }


        return $result;
    }

    public static function getPlanesOfExpressionChart($fullname) {
        global $reversePlanesOfExpression;

        $result = array('number' => 0, 'explanation' => '');

        $nameArray = split(' ', $fullname);

        $planesOfExpressionChart = array();

        foreach ($nameArray as $name) {
            for ($i = 1; $i <= strlen($name); $i++) {
                $planesOfExpressionChart[$reversePlanesOfExpression[strtolower(substr($name, ($i-1), 1))]['plane']][$reversePlanesOfExpression[strtolower(substr($name, ($i-1), 1))]['expression']]['letters'][] = strtolower(substr($name, ($i-1), 1));
            }
        }

        $result['chart'] = $planesOfExpressionChart;

        foreach ($planesOfExpressionChart as $plane => $planeArray) {

            foreach ($planeArray as $expression => $expressionArray) {

                foreach ($expressionArray as $letters) {

                    $tally = 0;
                    foreach ($letters as $letter) {
                        //$newarray[$plane][$expression] += self::letterValue(strtolower($letter));
                        $tally += self::letterValue(strtolower($letter));
                    }
                    $newarray['totals'][$plane][$expression] += self::reduce($tally);
                }

                $newarray['totals']['x'][$plane] += self::reduce($newarray['totals'][$plane][$expression]);
                $newarray['totals']['y'][$expression] += self::reduce($newarray['totals'][$plane][$expression]);
            } // end for each expression

        }

        foreach ($newarray['totals']['x'] as $plane => $total) {
            $newarray['totals']['x'][$plane] = self::reduce($total);
        }
        foreach ($newarray['totals']['y'] as $expression => $total) {
            $newarray['totals']['y'][$expression] = self::reduce($total);
        }

        $result['totals'] = $newarray['totals'];

        return $result;
    }
    
}