<?php
/**
 * @author  Daniel J Holmes dan@djcentric.com
 * Copyright (c) 2014, Daniel J Holmes
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Centric Web Estate.
 * 4. Neither the name of the Centric Web Estate nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 5. This product cannot be used in a commercial environment without the
 *    express written permission of the copyright holder.
 *
 * THIS SOFTWARE IS PROVIDED BY DANIEL J HOLMES ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL DANIEL J HOLMES BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE SITE NUMEROLOGIST.COM AND ITS OWNER HAVE BEEN PROVIDED WITH EXPRESS
 * WRITTEN PERMISSION FOR THE USE OF THIS PRODUCT AND COPYING ITS CONTENTS IN
 * FULL BUT NOT IN PART. THIS PRODUCT MAY BE COPIED TO MULTIPLE LOCATIONS ON
 * THE SERVER HOSTING NUMEROLOGIST.COM AND MAY NOT BE COPIED ELSEWHERE WITHOUT
 * EXPRESS WRITTEN PERMISSION.
 */

// Define our constant for #nothing
if(!defined('None'))
{
  define('None', 0);
}

class NumberHelpers
{
  protected static $NUMBER_VALUES = array(
    'a' => 1,
    'b' => 2,
    'c' => 3,
    'd' => 4,
    'e' => 5,
    'f' => 6,
    'g' => 7,
    'h' => 8,
    'i' => 9,
    'j' => 10,
    'k' => 11,
    'l' => 12,
    'm' => 13,
    'n' => 14,
    'o' => 15,
    'p' => 16,
    'q' => 17,
    'r' => 18,
    's' => 19,
    't' => 20,
    'u' => 21,
    'v' => 22,
    'w' => 23,
    'x' => 24,
    'y' => 25,
    'z' => 26
  );

  protected static $REDUCED_NUMBER_VALUES = array(
    'a' => 1,
    'b' => 2,
    'c' => 3,
    'd' => 4,
    'e' => 5,
    'f' => 6,
    'g' => 7,
    'h' => 8,
    'i' => 9,
    'j' => 1,
    'k' => 2,
    'l' => 3,
    'm' => 4,
    'n' => 5,
    'o' => 6,
    'p' => 7,
    'q' => 8,
    'r' => 9,
    's' => 1,
    't' => 2,
    'u' => 3,
    'v' => 4,
    'w' => 5,
    'x' => 6,
    'y' => 7,
    'z' => 8
  );

  /**
   * Alias for reduceNumber($number, None, 1)
   * @param  string/integer $number   The number to reduce
   * @return number                   Returns the reduced number
   */
  public static function fullReduceNumber ($number) {
    //return self::reduceNumber($number, None);
    if ($number == 0) return 0;
    $reduction = $number % 9;
    return ($reduction == 0) ? 9 : $reduction;
  }

  /**
   * Reduces numbers
   *
   * Reduces a given set of numbers to their lowest form and will stop on
   * any number specified.
   * @param  string/integer $number   The number to reduce
   * @param  array/int $stop_on_number  Stop if any of these numbers are found
   * @return number                   Returns the reduced number
   */
  public static function reduceNumber ($number, $stop_on_number, $reduce_to = 1)
  {
    // Make sure we're getting a string of numbers or an integer
    if (!is_integer($number) && !is_string($number))
    {
      throw new UnexpectedArgumentException('$number should be either a string of numbers or an int.');
    }

    // Need to cast to string so that we can split into a char array
    $number = trim((string) $number);

    // Make sure the cast to a string worked
    if(!is_string($number))
    {
      throw new UnexpectedArgumentException('$number should be a string of integers or an int convertable to a string.');
    }

    if(strlen($number) === 0)
    {
      throw new InvalidArgumentLength('$number cannot be an empty string');
    }

    // Check if $stop_on_number is valid
    if(!is_array($stop_on_number) && $stop_on_number !== None)
    {
      throw new InvalidArgument('Stop on number must be an array or int 0');
    }

    $chr_array = str_split((string) $number);

    // Find when we start having to check for stop numbers
    $max_length = 0;
    if(is_array($stop_on_number))
    {
      for ($i=0; $i<count($stop_on_number);$i++)
      {
        // Check to make sure we haven't already got a number we want to stop on
        //echo "Number: $number, Stop Check: {$stop_on_number[$i]}, Check? " . ($stop_on_number[$i] === ((int) $number)) . "\n";
        if ($stop_on_number[$i] === ((int) $number)) {
          return (int) $number;
        }

        $length = strlen((string) $stop_on_number[$i]);
        if ($length>$max_length)
        {
          $max_length = $length;
        }
      }
    }

    unset($number); // No longer need the original number

    // Begin to add all the numbers together
    $final_number = 0;
    foreach ($chr_array as $number)
    {
      $number = (int) $number; // Make sure number is now an int
      if(is_int($number))
      {
        $final_number += $number;
      }
    }

    /**
     * NOTE: if the next two if statements were reversed we'd have a bug
     * where it the function would rarely return a stop_number correctly.
     */
    // If our $final_number is a number we stop on then return
    if($max_length && strlen((string) $final_number) <= $max_length)
    {
      foreach($stop_on_number as $num) {
        if ($num === $final_number) {
          return $final_number;
        }
      }
    }

    // If we haven't reduced to the required length
    if (strlen((string) $final_number) > $reduce_to) {
      return NumberHelpers::reduceNumber($final_number, $stop_on_number);
    }

    // Looks like we're done!
    return $final_number;
  }

  public static function reduceStringToValue ($str, $only_these = null)
  {
    if (!is_string($str))
    {
      throw new UnexpectedArgumentException('$str must be a string. Type is ' . gettype($str));
    }


    if (is_null($only_these))
    {
      $only_these = array_keys(self::$REDUCED_NUMBER_VALUES);
    }

    // Convert strs with funny characters:
    // Make î = i etc.
    $rule = 'Any-Latin; NFD; [:Nonspacing Mark:] Remove; NFC; Lower;';
    $str = transliterator_transliterate($rule, $str);
    $name = str_split($str);

    $value = 0;

    foreach ($name as $char) {
      if (in_array($char, $only_these)) {
        $value += self::$REDUCED_NUMBER_VALUES[$char];
      }
    }
    
    return $value;
  }

  public static function getVowelString ($str){
    $regex = [
      '/(?:', //begin Regex
      '([aeiou])|', // match vowel
      '^(?:(y)[b-df-hj-np-tv-xz])|', // match start of string + y + consonant
      '(?:[b-df-hj-np-tv-xz](y))$|', // match consonant + y + end of string
      // '(?:[b-df-hj-np-tv-xz](y)([aeiou]))|', // match consonant + y + vowel
      // '(?:([aeiou])(y)[b-df-hj-np-tv-xz])|', // match vowel + y + consonant
      '[b-df-hj-np-tv-xz](y)[b-df-hj-np-tv-xz]|', //match y surrounded by consonant
      '[b-df-hj-np-tv-xz](ya)[b-df-hj-np-tv-xz]', //match y surrounded by consonant
      ')/' //end regex
    ];
    $regex = implode('', $regex);
    $matches = [];
    preg_match_all($regex, $str, $matches);

    array_shift($matches);
    $matches = call_user_func_array('array_merge', $matches);
    $vowel_string = implode('', $matches);
    return $vowel_string;
  }

  public static function getFirstVowel($str){
    $regex = [
      '/(?:', //begin Regex
      '([aeiou])|', // match vowel
      '^(?:(y)[b-df-hj-np-tv-xz])|', // match start of string + y + consonant
      '(?:[b-df-hj-np-tv-xz](y))$|', // match consonant + y + end of string
      // '(?:[b-df-hj-np-tv-xz](y)([aeiou]))|', // match consonant + y + vowel
      // '(?:([aeiou])(y)[b-df-hj-np-tv-xz])|', // match vowel + y + consonant
      '[b-df-hj-np-tv-xz](y)[b-df-hj-np-tv-xz]|', //match y surrounded by consonant
      '[b-df-hj-np-tv-xz](ya)[b-df-hj-np-tv-xz]', //match y surrounded by consonant
      ')/' //end regex
    ];
    $regex = implode('', $regex);
    $matches = [];

    preg_match_all($regex, $str, $matches);

    array_shift($matches);
    $matches = call_user_func_array('array_merge', $matches);
    return $matches;
  }



}

class InvalidFixedArraySizeException extends \Exception {};
class UnexpectedCharacterException extends \Exception {};
class UnexpectedArgumentException extends \Exception {};
class InvalidArgumentLength extends \Exception {};
class InvalidArgument extends \Exception {};
