<?php
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    require_once "classes/autoload.php";
    require_once("classes/Numerology.class.php");

    $dayNum = $_REQUEST['d'];
    $monthNum = $_REQUEST['m'];
    $yearNum = $_REQUEST['y'];
    $firstName = $_REQUEST['fn'];
    $fullBirthName = $_REQUEST['inputFullBirthName'];

    $dateObj   = DateTime::createFromFormat('!m', $monthNum);
    $monthName = $dateObj->format('F'); // January, etc.
    $fname = strtolower( $firstName );

    $a =  Calculator_Numerology::getExpressionNumber( $fullBirthName );
    $expression = $a['number'];

    $nameMatch = true; // is the name in our database of audio snippets? Yes for now, while testing...


    $slideshow = new JsSlideshow("images/bg.jpg", 640, 480);

    $slideshow->addAudio('audio/expression/expression-intro.mp3');  // e.g. Hey again! I'm so glad you decided to stick around ...
    $slideshow->addSlide(7.437);
    $slideshow->setFontSize(30);
    $slideshow->setTitle("'Expression' Name Analysis\n for <b>$firstName</b>\n\n Name at birth: \n<b><red>$fullBirthName</red></b>.");
    $slideshow->addTiles( $fullBirthName); 

    $slideshow->addCenteredTextSet(
        [ 1.924, "As you'll see for yourself in just a moment,"],
        [ 1.189, "Your <b>Expression</b> number"],
        [ 2.857, "or what is sometime referred to as your <b><red>Destiny</red></b> number"],
        [ 3.437, "is one of the most \n<b>telling elements</b> in\nyour Numerology Chart." ],
        [ 1.951, "Unlike your\nLife Path number" ],
        [ 2.350, "which uncovers \nyour most fulfilling \n<b>life direction</b>" ],
        [ 2.261, "and the <red>major lessons</red> \nyou’re <b>meant to learn</b>\n along the way," ],
        [ 3.813, "your <b>Expression</b> Number produces \n<red>highly potent and accurate profile</red>" ],
        [ 3.217, "of <b>who you are</b> and the <red>magic</red> you put out into the world." ],
        [ 2.789, "It reveals the\n <b>innate gifts</b> \nyou were born with" ],
        [ 1.980, "and predicts your <b>ultimate potential</b>" ],
        [ 3.678, "Your\n<b>Expression Number</b>\n is calculated by \n<red>adding up all the digits</red>" ],
        [ 4.477, "that correspond to\n the <red>letters of\nyour birth name</red> \n using the Pythagorean Alphabet." ],
        [ 3.003, "It can be a bit time consuming to do\nthe math by hand," ],
        [  NULL, "so I took the liberty\nof <red>calculating</red> and\n <red>interpreting</red> <b>your</b>\nExpression Number\nfor you." ]
    );

    $slideshow->clear();

    if ($nameMatch == true ){
        $f = "audio/name-youhave/".$fname."_youhave.mp3";
        $slideshow->addAudio( $f );
        $nameAudioLength = $slideshow->getAudioLen();
        $you = "$firstName, you";
    }else{
        $nameAudioLength = 0;
        $you = "You";
    }

    $slideshow->addAudio('audio/expression/expression-'.$expression.'.mp3');  // e.g. ""

    $slideshow->addSlide( 7.437 );
    $slideshow->setTitle("Numerology\nBirthname Analysis\n for\n<b><red>$fullBirthName</red></b>.\n");
    $slideshow->addTiles( $fullBirthName );

    switch ( $expression ) {
        case 1:
            $slideshow->addCenteredTextSet(
                [2.272,  "<b><red>1</red></b> is the number of a\n<b>natural leader</b>"],
                [1.406,  "You are assertive, ambitious, "],
                [2.155,  "and always ready to answer the call of duty."],
                [3.278,  "Determination and courage are your strongest inner gifts."],
                [2.756,  "You’ve probably found that failure only knocks at your door "],
                [2.351,  "when you don't rely on your own abilities"],
                [4.906,  "You achieve success by acting in a bold, forthright, and opportunistic fashion "],
                [1.067,  " – so keep it up."],
                [4.196,  "You’re incredibly confident which can sometimes rub people the wrong way. "],
                [4.635,  "While those with a lower sense-of-self may see you as selfish or egotistical at first"],
                [4.432,  "your unwavering loyalty and level-headedness makes you quick to defuse any tension "],
                [3.009,  "and inspire those around you to step up and succeed."],
                [3.652,  "You understand that a rising tide raises all ships. "],
                [2.945,  "Continue to celebrate and appreciate others’ achievements "],
                [ NULL,  "and it is almost guaranteed that you’ll attract enormous success in your life"] );
                break;
        case 2:
            $slideshow->addCenteredTextSet(
                [2.308,  "<b><red>2</red></b> is the number of\n<b>cooperation</b>"],
                [1.957,  "You are compassionate, diplomatic,"],
                [1.665,  "and an excellent communicator."],
                [2.054,  "You care deeply for those around you."],
                [3.761,  "Your strongest inner gifts are your ability to form powerful partnerships "],
                [2.689,  "and bring balance and harmony to any situation."],
                [3.116,  "You’ve probably found that failure only knocks at your door "],
                [3.352,  "when you get too tied-up in other people’s problems or insecurities. "],
                [5.276,  "You achieve great success through common effort and working in peaceful coexistence with your peers"],
                [1.032,  "– so keep it up!"],
                [2.050,  "Because you’re so reliable, "],
                [3.780,  "at times you get frustrated with others when their sense of cooperation slips "],
                [1.575,  "and they leave you hanging."],
                [4.656,  "But, when many others would think it a better idea to give up or “go at it solo”, "],
                [4.613,  "your patience and understanding always puts you back on top of a winning team."],
                [2.713,  "You have a rare gift for bringing out the best in people."],
                [2.551,  "Continue to lead by example and empower others "],
                [2.892,  "and it is almost guaranteed that you’ll make positive impressions "],
                [ NULL,  "that will open many doors for you."]
            );
            break;
        case 3:
            $slideshow->addCenteredTextSet(
                [2.6,  "<b><red>3</red></b> is the number of\n<b>charisma and creativity</b>"],
                [2.790,  "You are fun, spontaneous, and wildly popular."],
                [3.948,  "You effortlessly ignite the spark of enthusiasm and excitement in others,"],
                [1.024,  "and, as a result, "],
                [2.497,  "you earn a great amount of respect and admiration."],
                [2.250,  "This innate gift is the key to your success "],
                [1.052,  "– so keep it up!"],
                [2.876,  "You’ve probably found that failure only knocks at your door "],
                [2.224,  "when you lose focus of what YOU want "],
                [1.968,  "or let your spontaneity get the best of you. "],
                [2.790,  "You tend to “fly by the seat of your pants” "],
                [3.667,  "and while others sometimes accuse you of being flaky or unreliable, "],
                [3.386,  "you know the importance of follow-through and commitment."],
                [1.845,  "You have a rare gift of precognition "],
                [2.958,  "and may find that you have flashes about what’s to come. "],
                [2.644,  "This is a tremendous asset that allows you to "],
                [2.498,  "adapt quickly and deeply understand others. "],
                [2.879,  "Continue to bring joy and excitement to those around you "],
                [1.348,  "and it is almost guaranteed that"],
                [ NULL,  "you’ll live a prosperous and happy life. "]
            );
            break;
        case 4:
            $slideshow->addCenteredTextSet(
                [2.481,  "<b><red>4</red></b> is the number of\n<b>patience and stability</b>"],
                [2.640,  "You have a natural ability to keep both feet on the ground "],
                [1.753,  "and which is why others come to you frequently "],
                [1.721,  "seeking support and guidance."],
                [2.363,  "Your strongest inner gift is your ability to "],
                [2.472,  "put your head down and focus on the task at hand. "],
                [1.362,  "You get stuff done, "],
                [1.237,  "and done properly, "],
                [2.025,  "which makes you a force to be reckoned with. "],
                [2.587,  "This is most definitely the key to your success "],
                [1.248,  "– so keep it up!"],
                [2.801,  "You’ve probably found that failure only knocks at your door "],
                [1.961,  "when take on too much at once."],
                [2.778,  "You’re often called upon to lead new projects "],
                [1.867,  "and assume positions of responsibility,"],
                [2.651,  "which can leave you feeling limited and overwhelmed,"],
                [3.109,  "especially when others don’t have the same worth ethic you do."],
                [1.956,  "Despite this weight on your shoulders, "],
                [3.408,  "you have tremendous reserves of energy power to draw from. "],
                [2.340,  "Put this energy towards achieving your goals "],
                [ NULL,  "and you’ll be unstoppable."]
            );
            break;
        case 5:
            $slideshow->addCenteredTextSet(
                [2.338,  "<b><red>5</red></b> is the number of\n<b>freedom and variety</b>"],
                [2.453,  "You’re extremely\neasy-going and adaptable."],
                [1.442,  "You love to stay\nahead of the curve "],
                [2.066,  "and are always asking\n<red>“what’s next?!”</red>"],
                [1.530,  "You love to travel, "],
                [1.170,  "live in the fast lane "],
                [2.103,  "and handle quick\nchanges with grace."],
                [2.407,  "Your greatest gift is\nyour ability to multi-task "],
                [1.528,  "without breaking a sweat"],
                [2.758,  "You’ve probably found\nthat failure only\nknocks at your door "],
                [2.372,  "when you find yourself\nbored or unchallenged."],
                [2.160,  "Your versatility and\nquick-start personality "],
                [1.316,  "are the keys to your success "],
                [1.507,  " – so keep it up!"],
                [3.712,  "Your love of constantly\nchanging circumstances\nand unusual happenings "],
                [2.317,  "will keep your life\ncolorful and interesting. "],
                [1.788,  "While those more\nrigid than you "],
                [3.186,  "may question your\ncommitments or see you as\nunstable nor unreliable, "],
                [2.810,  "you know the importance of\nplanning and goal-setting."],
                [2.531,  "You have more spice in\nyour life than most. "],
                [3.071,  "Continue to focus\non building an\nempowering routine, "],
                [3.060,  "letting your intuition\nto guide you and\nhonoring your commitments "],
                [ NULL,  "and you’ll have more\nsuccess and fun than\nyou thought possible."]
            );
            break;
        case 6:
            $slideshow->addCenteredTextSet(
                [2.600,  "<b><red>6</red></b> is the number of\n<b>contribution and reliability</b>"],
                [2.418,  "You are\n<red> devoted and generous </red>\nin all that you do."],
                [2.767,  "Your sense of responsibility\nis rarely outmatched, "],
                [2.103,  "and it shows clearly\nin your love of others "],
                [1.743,  "and willingness to do\nwhatever it takes "],
                [1.361,  "to help someone in need"],
                [2.080,  "whether it be a friend\nor complete stranger."],
                [2.373,  "Your <red>greatest inner gift</red>\nis your ability to  "],
                [2.416,  "gain an unwavering sense\nof trust from others."],
                [2.365,  "This dependability and\nstrength of character "],
                [1.203,  "are the keys to your success "],
                [1.215,  "– so keep it up!"],
                [2.791,  "You’ve probably found\nthat failure only\nknocks at your door "],
                [1.955,  "when you undermine\nyour own integrity "],
                [2.441,  "by sacrificing too much\nfor the benefit of others."],
                [1.868,  "Because of your\ndependable nature, "],
                [2.001,  "you tend to attract\ndependent people"],               // AUDIO SAYS **DIFFERENT** PEOPLE
                [1.583,  "in your personal\nand professional life,"],
                [1.555,  "so keep a watchful eye."],
                [3.892,  "Set boundaries and\navoid absorbing others’\nproblems as your own."],
                [1.417,  "You are full of love."],
                [2.104,  "Continue to\nfocus on your own\ngoals and ambitions, "],
                [1.203,  "as well as those of others"],
                [1.285,  "and that love will multiply "],
                [ NULL,  "and take your success\nto a whole new level"]
            );
            break;
        case 7:
            $slideshow->addCenteredTextSet(
                [2.100,  "<b><red>7</red></b> is the number of\n<b>spirit</b>"],
                [2.127,  "You have the most\nmystical expression\nof them all!"],
                [2.642,  "You are a truth-seeker\nand tend to delve deeply "],
                [2.058,  "into the secrets of\nnature and the\nhuman mind, "],
                [3.129,  "either through science or\nby more esoteric methods."],
                [2.101,  "You’re creative and philosophical "],
                [2.461,  "which make you a natural\nvisionary and teacher."],
                [1.602,  "Your greatest internal gift "],
                [2.327,  "is the ability to\nsee the “big picture”"],
                [1.700,  "while staying true\nto your purpose. "],
                [2.596,  "Your wisdom and presence\nare the keys to your success "],
                [1.091,  " – so keep it up!"],
                [2.520,  "You’ve probably found\nthat failure only\nknocks at your door "],
                [1.361,  "when you spend too much time "],
                [1.655,  "focusing on trivial details."],
                [2.631,  "Others often see you\nas too philosophical "],
                [1.658,  "or intellectually superior."],
                [3.712,  "While this can make the\nsocial aspects of life\na bit difficult for you, "],
                [1.672,  "you always make a\nconcerted effort "],
                [2.234,  "ally with others who\nare different from you "],
                [2.322,  "to gain valuable\ninsight and experience."],
                [3.428,  "This garners you\nmuch admiration and respect\nfrom your peers."],
                [2.084,  "You have a rare gift\nof teaching others "],
                [2.126,  "in a very positive\nand uplifting way."],
                [1.610,  "Continue to seek answers "],
                [3.430,  "and keep your materialistic\nand spiritual viewpoints\nin harmony "],
                [1.124,  "and you’ll be able to achieve"],
                [ NULL,  "anything you set your mind to."]
            );
            break;
        case 8:
            $slideshow->addCenteredTextSet(
                [1.600,  "<b><red>8</red></b> is the number of\n<b>achievement</b>"],
                [1.352,  "You’re likely to achieve success"],
                [1.732,  "more easily than anyone else."],
                [2.767,  "You’re a managerial and\norganizational genius "],
                [2.351,  "with strong intellect\nand determination."],
                [1.858,  "Your greatest gift\nis your confidence "],
                [2.124,  "and ability to move\nthe needle quickly."],
                [2.688,  "You’ve probably found\nthat failure only\nknocks at your door "],
                [1.923,  "when others\nget in the way\nof your objectives."],
                [2.724,  "People often look to you for motivation and direction "],
                [1.810,  "and these are\nthe keys to your\nown success "],
                [1.113,  " – so keep it up!"],
                [1.915,  "Because you move\nfaster than most,"],
                [2.719,  "you get easily frustrated\nby delays or inaction "],
                [2.654,  "and often take on\nmore work in order\nto compensate."],
                [1.766,  "In order to avoid stress, "],
                [1.293,  "remember to slow down "],
                [2.137,  "take a step back\nfrom time to time. "],
                [2.092,  "Funnel that abundant\nenergy into yourself "],
                [1.045,  "and your relationships "],
                [2.644,  "and watch the tension\nand resistance fade away."],
                [2.846,  "You have a rare gift\nof achieving\noutstanding results."],
                [2.497,  "Continue to temper your\ndiscipline and ambition"],
                [1.473,  "with patience and compassion "],
                [ NULL,  "and you’ll experience thrill,\nhappiness, and success\nin all you do."]

            );
            break;
        case 9:
            $slideshow->addCenteredTextSet(
                [2.200,  "<b><red>9</red></b> is the number of\n<b>quiet power</b>"],
                [2.929,  "You’re independent, compassionate,\nand highly sensitive."],
                [1.627,  "While you have strong emotions, "],
                [2.418,  "you have more resilience\nand tolerance than most."],
                [2.295,  "You see disappointment\nas opportunity "],
                [1.586,  "and challenge as adventure "],
                [1.046,  "and, because of this,"],
                [1.955,  "you’re always progressing\nand expanding. "],
                [3.827,  "Your greatest gift is\nyour ability to recover\nquickly from setbacks."],
                [1.800,  "Your “get up and\ntry again” attitude "],
                [1.315,  "the key to your success "],
                [1.102,  " – so keep it up!"],
                [2.722,  "You’ve probably found\nthat failure only\nknocks at your door"],
                [1.968,  "when you focus too much\ntime and energy "],
                [2.250,  "on obtaining material\nwealth and power "],
                [3.453,  "and that’s because you’re\nmore spiritually-evolved\nthan most."],
                [3.028,  "You believe that\nwinning is about\ncoming out <red>right</red> "],
                [1.715,  "rather than\ncoming out on top."],
                [3.706,  "You have a rare gift\nof unmatched compassion\nand wisdom. "],
                [1.439,  "Continue to cultivate this "],
                [1.756,  "and channel your power\ninto helping others "],
                [1.573,  "and you’ll bring\njoy and success "],
                [1.766,  "into the lives of\neveryone around you, "],
                [ NULL,  "including yourself."]
            );
            break;
        case 11:
            $slideshow->addCenteredTextSet(
                [3.000,  "<b><red>11</red></b> is the master number of\n<b>inspiration and intuition</b>"],
                [1.080,  "You are a visionary "],
                [1.327,  "and often see the outcome "],
                [1.863,  "of circumstances\n<red>before</red> they happen."],
                [1.759,  "This makes you highly creative "],
                [2.711,  "and someone who always thinks outside of the box."],
                [2.778,  "You’ve probably found that failure only knocks at your door "],
                [1.137,  "when you feel constrained "],
                [2.001,  "or stunted in your creativity."],
                [1.406,  "A free spirit by nature,"],
                [1.968,  "you often let your\n<red>heart</red> guide you "],
                [1.091,  "in your decision-making."],
                [1.733,  "Your greatest gift\nis your <red>intuition</red> "],
                [1.247,  "and the way you use it "],
                [1.687,  "to <b>inspire</b> and\n<b>empower</b> others."],
                [2.462,  "This unique perspective\nand open expression"],
                [1.412,  "is the key to your success "],
                [1.244,  "– so keep it up!"],
                [2.021,  "Your strong character\nand individuality "],
                [1.894,  "can be hard for\nothers to understand."],
                [2.800,  "While this can make\nrelationships and\ncollaboration difficult, "],
                [1.496,  " you are always\n<red>open to learning</red> "],
                [0.990,  "from those around you -"],
                [2.306,  "– even if they seem\nboring, rigid, or mundane - "],
                [1.833,  "which garners you\nmuch admiration "],
                [1.462,  "and respect\nfrom your peers."],
                [3.015,  "Continue to be the\n<red>inspiring visionary</red> you are"],
                [1.709,  "and account for the\nfact that others might"],
                [1.823,  "“just see it differently”."],
                [2.722,  "This harmony will\ninspire more <red>creativity</red> "],
                [1.001,  "in those around you "],
                [2.621,  "and create more <red>connection</red>,\n<red>happiness</red>, and <red>success</red> "],
                [ NULL,  "in all you do."]
            );
            break;
        case 22:
            $slideshow->addCenteredTextSet(
                [2.3,  "<b><red>22</red></b> is the <b>master number</b>\n of <b>creation</b>"],
                [2.070,  "It is likely that you make <red>big plans</red> "],
                [1.812,  "and always have the\nbig picture in mind."],
                [2.204,  "You have grandiose goals\nand are interested in"],
                [2.340,  "building things that\n“move the world”. "],
                [3.276,  "Your 10,000-foot view\nis awe-inspiring "],
                [1.854,  "and you gain energy\nfrom the momentum"],
                [1.847,  "that’s created when\nstarting something new! "],
                [2.314,  "Your greatest gift\nis the ability to"],
                [1.586,  "see the potential\nin everything."],
                [1.327,  "Your energy and enthusiasm "],
                [1.529,  "are the keys to your success "],
                [1.158,  "– so keep it up!"],
                [2.760,  "You’ve probably found\nthat failure only\nknocks at your door "],
                [2.380,  "when your unshakeable focus\non the grand vision "],
                [2.002,  "makes you lose sight\nof the smaller details "],
                [1.473,  "critical to your success."],
                [1.999,  "Be sure to prioritize\nand organize "],
                [2.239,  " to avoid “biting off\nmore than you can chew” "],
                [2.632,  "and use your enthusiasm\nto attract people "],
                [2.306,  "who help you achieve\nyour lofty goals."],
                [2.171,  "You have a rare gift\nof motivating"],
                [1.759,  "and inspiring others\nto take action"],
                [1.930,  "Continue to\nreach for the stars "],
                [1.585,  "while uplifting\nthose around you "],
                [ NULL,  "and you’ll be a force\nto be reckoned with."]
            );
            break;
        default:
            throw new exception( "Huh? Unknown Expression!");
    }

    $slideshow->clear();


    if ($nameMatch == true )
    {
        $f = "audio/name-youhave/".$fname."_youhave.mp3";
        $slideshow->addAudio( $f );
        $please = "$firstName, please";
    }else{
        $please = "Please";
    }
    $slideshow->addAudio('audio/expression/expression-outro.mp3');

    $slideshow->addCenteredTextSet(
        [2.000 + $nameAudioLength, "$please know that there is still SO much left"],
        [2.725, "to explore in your unique Numerology Chart..."],
        [1.177, "And if you’ll allow me,"],
        [1.754, "I’d like to give you\neven <red>more</red> insight"],
        [2.463, "into your <b>life</b>,\n <b>relationships</b>, and\n<b>true purpose</b>"],
        [2.769, "by analyzing your\n<red><b>Soul Urge Number</b></red>."],
        [1.743, "Your Soul Urge Number,"],
        [2.406, "also called your\n<red><b>Heart’s Desire</b></red> Number, "],
        [1.878, "represents the <b>inner you</b>. "],
        [2.161, "It exposes your\n<b>hidden motivations</b>, "],
        [1.810, "<b>deepest cravings</b>\nand <b>urges</b>,"],
        [1.417, "<b>likes</b> and <b>dislikes</b>."],
        [1.631, "It reveals the <b>true intention</b> "],
        [2.239, "behind most of your\n<red>actions</red> and <red>decisions</red>."],
        [0.900, "In just a minute,"],
        [2.933, "you’ll discover your\n<b>Soul Urge Number</b>\nand meaning."],
        [2.556, "I just need 2 more pieces of information from you "],
        [1.372, "to complete your profile... "],
        [ NULL, "Please complete the information below."]
    );

    $slideshow->addCallback('showEmailForm');

    $compiledSlideshowPath = $slideshow->compile();
    header("Location: demoplayer.html#!".$slideshow->getID());
