<?php

  include 'vendor/autoload.php';

  /****************
  / LANDING PAGE PRESENTATION
  ***************/
  require_once "classes/autoload.php";
  require_once "classes/Numerology.class.php";

  $showLanding = false;
  $hops = array('askangels','accessloa','brainev','manimir','mindmovies','mindvalley');
  $hop_names = array('askangels' => 'Ask Angels',
                    'accessloa' => 'Greater Minds',
                    'brainev' => 'Karl Moore',
                    'manimir' => 'Manifestation Miracle',
                    'mindmovies' => 'Mind Movies',
                    'mindvalley' => 'MindValley'
                );
  //versions array: l - long version, m - medium version, s - short version
  $versions = array('l','m','s');
  $default_version = ( isset($_GET['test_version']) && in_array($_GET['test_version'],$versions) ) ? $_GET['test_version'] : 'm';

  $firstName = ucfirst($_GET['n']);
  $fname = strtolower( $firstName );
  $nameExist  = file_exists("audio/hi-name/hi-$fname.mp3");

  $hop = $_GET['hop'];
  $version = ( isset($_GET['v']) && in_array($_GET['v'],$versions) ) ? $_GET['v'] : $default_version;
  
  $slideshow = new JsSlideshow("images/bg.jpg", 640, 480);
  include 'freevideo/landing-presentation/'.$version.'-version.php';
  $compiledSlideshowPath = $slideshow->compile();
  $slideshowid = $slideshow->getID();

  $showLanding = true;

?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta property="fb:app_id" content="946714615388548" />
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>Numerologist - Personalized Life Reading</title>

    <link rel="icon" href="images/favicon.png" type="image/gif">


    <!-- web fonts -->

    <link href='http://fonts.googleapis.com/css?family=Raleway:400,300,500,600,700,200,100|Source+Sans+Pro:400,300,300italic,400italic,600,600italic,700,700italic' rel='stylesheet' type='text/css'>

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/app.css" rel="stylesheet">
    <!-- custom select box -->
    <!--<link rel="stylesheet" href="http://gregfranko.com/jquery.selectBoxIt.js/css/jquery.selectBoxIt.css" />-->

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js"></script>
    <script src="js/jquery.jplayer.min.js"></script>
    <script src="js/numerologyslideshow.js"></script>
    <link rel="stylesheet" type="text/css" href="css/app.css" />
    <link rel="stylesheet" type="text/css" href="css/numerologyslideshow.css" />
    <script src="//cdn.optimizely.com/js/64607647.js"></script>

  </head>
  <body>
    <!-- Google Tag Manager -->
    <noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-K56LND" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src='//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);})(window,document,'script','dataLayer','GTM-K56LND');</script>
    <!-- End Google Tag Manager -->
    <!--script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script-->

  <!-- gplus share script -->
  <!--<script src="https://apis.google.com/js/platform.js" async defer></script>-->

  <!-- facebook box sdk script -->

  <div id="fb-root"></div>
  <script>(function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.3";
    fjs.parentNode.insertBefore(js, fjs);
  }(document, 'script', 'facebook-jssdk'));</script>

  <!-- facebook box sdk script end -->

   <!-- twiiter widget javascript -->
  <script>window.twttr = (function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0],
      t = window.twttr || {};
    if (d.getElementById(id)) return t;
    js = d.createElement(s);
    js.id = id;
    js.src = "https://platform.twitter.com/widgets.js";
    fjs.parentNode.insertBefore(js, fjs);

    t._e = [];
    t.ready = function(f) {
      t._e.push(f);
    };

    return t;
  }(document, "script", "twitter-wjs"));</script>

  <!-- twiiter widget javascript end -->

    <?php include 'header.php';?>


    <section class="main">
      <?php if($showLanding): ?>
        <section id="landing-page-presentation">
          <div class="container">
            <div class="row">
              <div class="col-md-2"></div>
              <div class="col-md-8">
                <div id="slidePlayer">
                  <div id="imgdisplay" class="b">
                    <div id="slidecontent" class="loading"></div>
                  </div>
                </div>
                <div id="sound"></div>
              </div><!--/.col-md-8-->
              <div class="col-md-2"></div>
            </div><!--/.row-->
          </div><!--/.container-->
        </section><!--/#landing-page-presentation-->
      <?php else: ?>
        <div style="width:100%; height:240px;"></div>
      <?php endif;?>

      <section class="optin-form arrow-section"> <!-- optin here -->
        <div class="inner-option-section">
            <div class="container-fluid">
              <div class="row">
                <div class="col-sm-4 form-head">
                  <div class="arrow-right hidden-xs"></div>
                  <p class="title"><span class="title-small">Start Your Free Personalized Video</span> <strong>Numerology Report</strong></p>
                  <div class="arrow-down hidden-sm hidden-md hidden-lg"></div>
                </div>
                <div class="col-sm-8 form-wrap">
                  <p class="tyellow form-title">Enter your first name and date of birth to get your free personalized video report Instantly!</p>
                  <!--<p class="tteal form-title sub">No email or credit card required</p>-->
                  <div class="form-fields">
                    <form class="form-inline" action="continue.php" method="get" id="top-form" onSubmit="return topValidate();">
                      <input type="hidden" name="affiliate" value="true">

                      <div class="form-group form_inner fname-inner">
                        <div class="form-col fname">
                          <!--<span class="name-icon"><img src="images/name.png" alt=""></span>-->
                          <input name="inputFirstName" type="text" class="form-control on-focus" id="firstNameT" placeholder="First Name" value="<?php echo (isset($_GET['n'])) ? ucfirst($_GET['n']) : ''; ?>">
                        </div>
                      </div>

                      <div class="form-group form_inner">
                        <div class="form-col select mySelect">
                          <div class="form-group month">
                            <!--<span class="cake-icon"><img src="images/cake.png" alt=""></span>-->
                            <select class="form-control on-select-focus" id="tMonth" name="inputDateMonth">
                              <option value="">Month</option>
                              <?php for ($i=1; $i <= 12; $i++): $month_name = date( 'F', mktime( 0, 0, 0, $i + 1, 0, 0, 0 ) ); ?>
                                <option value="<?php echo $i;?>"><?php echo $month_name;?></option>
                              <?php endfor;?>
                            </select>
                          </div>
                          <div class="form-group day">


                            <select class="form-control on-select-focus-day" id="tDay" name="inputDateDay">
                              <option value="">Day</option>
                              <?php for($i=1;$i<=31;$i++):?>
                                <option><?php echo $i;?></option>
                              <?php endfor;?>
                            </select>

                          </div>
                          <div class="form-group year">

                            <select class="form-control on-select-focus-year" id="tYear" name="inputDateYear">
                              <?php for($i=1910;$i<(date('Y'));$i++):?>
                                <option <?php echo ($i == 1950) ? ' selected' : '' ?>><?php echo $i;?></option>
                              <?php endfor;?>
                            </select>

                          </div>
                        </div>
                      </div>

                      <div class="form-group send">
                        <!-- <a href="video1.php" type="submit" class="btn btn-purple multiple up">Get my free <br>reading now!</a> -->
                        <input type="hidden" name="step" value="1">
                        <input type="hidden" name="version" value="b">
                        <?php
                          foreach($_GET as $getname => $getval){
                            echo '<input type="hidden" name="' . $getname . '" value="' . $getval . '">';
                          }
                        ?>
                        <button type="submit" class="btn btn-purple multiple up">Get my free <br>report now!</button>
                        <p class="disclaimer small"><a href="http://numerologist.com/portal/privacy-policy/">We respect your privacy</a></p>
                      </div>
                    </form>
                  </div>
                  <p class="tteal form-title sub">No email or credit card required</p>
                </div>
              </div>
            </div>
        </div>
      </section>

    </section>

    <section class="fb-like">
      <div class="container">
        <div class="row">
          <div class="col-sm-1"></div>
          <div class="col-sm-10">
            <div class="like-wrap">
              <p class="text-center lead">
                Over <span class="tpurple">401,289</span> Abundant Thinkers Trust Numerologist to Find & Stay on Life Path...
              </p>
              <div class="divider yellow"></div>

              <div class="fb-code text-center">

                <div class="fb-page" data-href="https://www.facebook.com/numerologistcom" data-width="900" data-small-header="false" data-adapt-container-width="true" data-hide-cover="false" data-show-facepile="true" data-show-posts="false"><div class="fb-xfbml-parse-ignore"><blockquote cite="https://www.facebook.com/numerologistcom"><a href="https://www.facebook.com/numerologistcom">Numerologist.com</a></blockquote></div></div>

              </div>

            </div>
          </div>
          <div class="col-sm-1"></div>
        </div>
      </div>
    </section>


    <section class="benefits">
      <div class="container">
        <div class="row">
          <div class="col-sm-12 text-center">
            <h2 class="tpurple">The 3 Keys of Life...</h2>
            <p class="subhead">No matter where you are on your path, and no matter what you're told by others</p>
          </div>

          <div class="col-sm-4">
            <div class="col yellow">
              <p class="col-icon"><img src="images/purpose.png" alt="" class="center-block"></p>
              <div class="col-desc text-center">
                <h4 class="tyellow">Purpose</h4>
                <p>Our most difficult challenge in this life is to define our purpose for being. Our experts will guide you step by step to find your purpose.</p>
              </div>
            </div>
          </div>
          <div class="col-sm-4">
            <div class="col teal">
              <p class="col-icon"><img src="images/plan.png" alt="" class="center-block"></p>
              <div class="col-desc text-center">
                <h4 class="tteal">Plan</h4>
                <p>Once your purpose is revealed, you need a plan to reach your new goals. Our reports will help you know when to act, and when to wait.</p>
              </div>
            </div>
          </div>
          <div class="col-sm-4">
            <div class="col purple">
              <p class="col-icon"><img src="images/confirmation.png" alt="" class="center-block"></p>
              <div class="col-desc text-center">
                <h4 class="tpurple">Confirmation</h4>
                <p>Without confirmation that you are on your plan, it can be confusing if you are still on path. Our reports help you validate your daily intent and results.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>


    <section class="optin-form footer arrow-section"> <!-- footer optin here -->
      <div class="inner-option-section">
          <div class="container-fluid">
            <div class="row">
              <div class="col-sm-4 form-head">
                <div class="arrow-right hidden-xs"></div>
                <p class="title"><span class="title-small">Start Your Free Personalized Video</span> <strong>Numerology Report</strong></p>
                <div class="arrow-down hidden-sm hidden-md hidden-lg"></div>
              </div>
              <div class="col-sm-8 form-wrap">
                <p class="tteal form-title">Fill in your name and birthdate to get started!</p>
                <div class="form-fields">
                  <form class="form-inline" id="bottom-form" action="continue.php" method="get" onSubmit="return bottomValidate();">
                    <input type="hidden" name="affiliate" value="true">

                    <div class="form-group form_inner fname-inner">
                      <div class="form-col bfname">
                        <!--<span class="name-icon"><img src="images/name.png" alt=""></span>-->
                        <input name="inputFirstName" type="text" class="form-control on-focus" id="firstNameB" placeholder="First Name" value="<?php echo (isset($_GET['n'])) ? ucfirst($_GET['n']) : ''; ?>">
                      </div>
                    </div>

                    <div class="form-group form_inner">
                      <div class="form-col select mySelect btmSlec">
                        <div class="form-group month btm-month">
                          <!--<span class="cake-icon"><img src="images/cake.png" alt=""></span>-->
                          <select class="form-control on-select-focus" id="bMonth" name="inputDateMonth">
                             <option value="">Month</option>
                              <?php for ($i=1; $i <= 12; $i++): $month_name = date( 'F', mktime( 0, 0, 0, $i + 1, 0, 0, 0 ) ); ?>
                                <option value="<?php echo $i;?>"><?php echo $month_name;?></option>
                              <?php endfor;?>
                          </select>
                        </div>

                        <div class="form-group day btm-day">
                          <select class="form-control on-select-focus-day" id="bDay" name="inputDateDay">
                            <option value="">Day</option>
                              <?php for($i=1;$i<=31;$i++):?>
                                <option><?php echo $i;?></option>
                              <?php endfor;?>
                          </select>
                        </div>

                        <div class="form-group year btm-year">
                          <select class="form-control on-select-focus-year" id="bYear" name="inputDateYear">
                              <?php for($i=1910;$i<(date('Y'));$i++):?>
                                <option <?php echo ($i == 1950) ? ' selected' : '' ?>><?php echo $i;?></option>
                              <?php endfor;?>
                          </select>
                        </div>
                      </div>
                    </div>

                    <div class="form-group send">
                      <input type="hidden" name="step" value="1">
                      <input type="hidden" name="version" value="b">

                      <?php
                        foreach($_GET as $getname => $getval){
                          echo '<input type="hidden" name="' . $getname . '" value="' . $getval . '">';
                        }
                      ?>
                      <button type="submit" class="btn btn-purple multiple up">Get my free <br>report now!</button>
                      <p class="disclaimer small"><a href="http://numerologist.com/portal/privacy-policy/">We respect your privacy</a></p>
                    </div>
                  </form>

                </div>
                <p class="tteal form-title sub">No email or credit card required</p>
              </div>
            </div>
          </div>
      </div>
    </section>

    <?php include 'footer.php';?>

    <script src="js/jquery.noty.packaged.min.js"></script>
    
    <?php if($showLanding): ?>
      <script>
          $(function(){
              $show = NumerologySlideshow("#sound","https://storage.googleapis.com/numerologist-888.appspot.com/slides/<?php print $slideshowid;?>/slideshow.json");
          });
      </script>
    <?php endif;?>

    <script type="text/javascript">
    var notyId = "";
    function generateMsg(msg,layout,type,time) {
      var timeOut = 3000;
      if(time != "" && time > timeOut) {
        timeOut = time;
      }
      var arrayNotyTextContainers = $('.noty_text');
      for( var i=0; i<arrayNotyTextContainers.length; i++ ){
        if( $(arrayNotyTextContainers[i]).text() == msg )
          return; // The same notification is already being displayed. Don't duplicate the notification
      }

      var n = noty({
        text        : msg,
        type        : type,
        dismissQueue: true,
        layout      : layout,
        timeout   : timeOut,
        theme       : 'relax'
      });
      notyId = n.options.id;
    }
  </script>
    <!--<script src="https://s3.amazonaws.com/media.numerologist.com/jselectboxit.min.js"></script>-->

    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <!--<script src="js/bootstrap.min.js"></script>-->
    <script src="js/app.js"></script>
    <script src="js/jquery.validate.min.js"></script>
    <script>
    $('#firstNameT').bind('keyup blur', function(){
      $(this).val( $(this).val().replace(/[^a-z A-Z]/g,'') );
    });
    $('#firstNameB').bind('keyup blur', function(){
      $(this).val( $(this).val().replace(/[^a-z A-Z]/g,'') );
    });
        $('#bottom-form').validate({
          ignore:''
        });
        $('#top-form').validate({
          ignore:''
        });
    function topValidate()
    {
      var tfName = $('#firstNameT').val();
      var tmonth = $('#tMonth').val();
      var tdate = $('#tDay').val();
      var tyear = $('#tYear').val();
      if(tfName=="")
      {
        generateMsg("Please enter your Name!","topCenter","warning");
        if(!(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)))
        {
          $('#firstNameT').focus();
        }
        return false;
      }
      else if(tmonth=="")
      {
        generateMsg("Please select Month!","topCenter","warning");
        $('#tMonth').focus();
        return false;
      }
      else if(tdate=="")
      {
        generateMsg("Please select Day!","topCenter","warning");
        $('#tDay').focus();
        return false;
      }
      else if(tyear=="")
      {
        generateMsg("Please select Year!","topCenter","warning");
        $('#tYear').focus();
        return false;
      }
      else
      {
        return true;
      }
    }
    function bottomValidate()
    {
      var bfName = $('#firstNameB').val();
      var bmonth = $('#bMonth').val();
      var bdate = $('#bDay').val();
      var byear = $('#bYear').val();
      if(bfName=="")
      {
        generateMsg("Please enter your Name!","topCenter","warning");
        $('.bfname').focus();
        if(!(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)))
        {
          $('#firstNameB').focus();
        }
        return false;
      }
      else if(bmonth=="")
      {
        generateMsg("Please select Month!","topCenter","warning");
        $('#bMonth').focus();
        return false;
      }
      else if(bdate=="")
      {
        generateMsg("Please select Day!","topCenter","warning");
        $('#bDay').focus();
        return false;
      }
      else if(byear=="")
      {
        generateMsg("Please select Year!","topCenter","warning");
        $('#bYear').focus();
        return false;
      }
      else
      {
        return true;
      }
    }
    </script>
  </body>
</html>
