<?php
    //error_reporting(E_ALL);
    ini_set('display_errors', 0);

    require_once "classes/autoload.php";
    require_once "classes/Numerology.class.php";


    $firstName  = ucwords( $_REQUEST['inputFirstName'] );
    $dayNum     = (int)$_REQUEST['inputDateDay'];
    $monthNum   = (int)$_REQUEST['inputDateMonth'];
    // var_dump($monthNum);exit;
    $yearNum    = (int)$_REQUEST['inputDateYear'];
    $fullBirthName = $_REQUEST['inputFullBirthName'];

    
    if(!array_key_exists('lifepath',$_REQUEST)){
        $lifePath =  Calculator_Numerology::getLifePathNumber($yearNum, $monthNum, $dayNum);
    } else {
        $lifePath = $_REQUEST['lifepath'];
    }

    if(!array_key_exists('expression',$_REQUEST)){
        $a =  Calculator_Numerology::getExpressionNumber( $fullBirthName );
        $expression = $a['number'];
    } else {
        $expression = $_REQUEST['expression'];
    }

    $current_date = new DateTime();
    $birthdate = new DateTime($yearNum.'-'.$monthNum.'-'.$dayNum);
    $age = $current_date->diff($birthdate);
    $age = $age->format('%y');

    include 'vendor/autoload.php';


    $dateObj    = DateTime::createFromFormat('!m', $monthNum);
    $monthName  = $dateObj->format('F'); // January, etc.
    $fname      = strtolower( $firstName );

    // Most popular US names
    //https://en.wikipedia.org/wiki/List_of_most_popular_given_names_by_state_in_the_United_States
    $namesMale   = array("adrian","aiden","alexander","andrew","angel","anthony","austin","benjamin","bentley","brantley","braxton","brayden","brody","caleb","cameron","carlos","carter","charles","chase","christian","christopher","colton","connor","daniel","david","diego","dylan","easton","eli","elijah","ethan","evan","ezekiel","gabriel","gavin","henry","hudson","hunter","ian","isaac","isaiah","jace","jack","jackson","jacob","james","jaxon","jayden","jeremiah","jesus","john","jose","joseph","joshua","josiah","juan","kevin","landon","levi","liam","lincoln","logan","lucas","luis","luke","mason","matthew","micah","michael","nathan","nicholas","noah","oliver","owen","parker","robert","ryan","ryker","samuel","sebastian","tyler","william","wyatt","yadiel");
    $namesFemale = array("aaliyah","abigail","addison","adriana","alanis","alexandra","alexis","allison","alondra","alyssa","amanda","amelia","andrea","anna","aria","ariana","ashley","aubree","aubrey","aurora","ava","avery","brianna","brooklyn","camila","charlotte","chloe","claire","eleanor","elizabeth","ella","ellie","emily","emma","evelyn","faith","gabriela","gabriella","genesis","gianna","grace","hadley","hailey","hannah","harper","isabella","julia","kamila","katherine","kayla","kaylee","khloe","layla","leah","lillian","lily","lucy","lydia","madison","makayla","mary","maya","mia","naomi","natalie","nevaeh","nicole","nora","oakley","olivia","paisley","paola","riley","ruby","sadie","samantha","sarah","serenity","sofia","sophia","taylor","valeria","victoria","wendy","zoe","zoey");

    $genderMale = in_array( strtolower(trim($firstName)), $namesMale);
    $genderFemale = in_array( strtolower(trim($firstName)), $namesFemale);
    $gender = ($genderMale != $genderFemale) ?  ( $genderMale ? 'male' : 'female' ) : FALSE;



    $nameMatch  = file_exists("audio/hi-name/hi-$fname.mp3"); // is the name in our database of audio snippets? Yes for now, while testing...

    $slideshow = new JsSlideshow("images/bg.jpg", 640, 480);


    if ($nameMatch == true ) {
        $f = "audio/hi-name/hi-$fname.mp3"; // e.g. "Hi Dan,"
        $slideshow->addAudio( $f );
        $nameAudioLength = $slideshow->getAudioLen();
    }else {
        $nameAudioLength = 0;
    }
    $slideshow->addAudio('audio/lifepath/subscriber-lifepath-intro.mp3');

    $slideshow->addSlide(9.4+$nameAudioLength); //Add empty slide with 6 sec duration
    $slideshow->setFontSize(30, "pt"); // Default is px, if we ned use other, just pass it in second argument
    $slideshow->setTitle("Numerology Reading\n for <b>$firstName</b>\n Born \n<b><red>$monthName $dayNum, $yearNum</red></b>.");
    $slideshow->addBirthTiles( $yearNum , $monthNum, $dayNum );


//  $slideshow->addCallback('showForm');    // BLAIR - just temporary, to speed up testing
    $slideshow->addCallback('videoStart');
/*
    $slideshow->addCenteredTextSet(
        [ 1.3, "Over the next few minutes,"],
        [   3, "I'm going to give you a quick yet <red>deeply revealing</red> analysis"],
        [ 2.1, "of your unique Numerology Chart" ],
        [NULL, "based on your\n<b>given name </b>($firstName)\nand <b>date of birth</b>\n($monthName $dayNum, $yearNum)" ]
        //In the last record we omit the $time argument, this means the slide will be shown until the end of the audio file
    );
*/
    /*
     * If the name is one in our audio database, greet the user by a recording of their name,
     * also noting the length of this recording for sync purposes.
     */

/*
    if ($nameMatch == true ) {
        $f = "audio/name-youhave/".$fname."_youhave.mp3"; // 'you have' is just an indicative pronunciation of the words that might follow the name, and is not in the recording!
        $slideshow->addAudio( $f );
        $nameAudioLength = $slideshow->getAudioLen();
        $there = "$firstName, there";
    }else {
        $nameAudioLength = 0;
        $there = "There";
    }


    $slideshow->addAudio('audio/lifepath/lifepath-intro-part2.mp3'); // {NAME}, there are 5 elements that form the “core” of your chart and that most massively impact your life. etc.
*/



    $slideshow->addCenteredTextSet(
        [4.014, "The most important number in your numerology chart is your <red><b>Life Path</b></red>..." ],
        [4.800, "It reveals your\nmost fulfilling life direction\nand the <red>major lessons</red>\n you’re here to learn… " ],
        [3.730, "it highlights the\n<b>specific opportunities</b> \nand <b>challenges</b> you will encounter," ],
        [3.746, "and your\n<red>unique personality traits</red>\nthat will help you on your journey." ],
        [ NULL, "Your Life Path is\ncalculated by simply\nadding up the digits\nof your <b>date of birth</b>." ]
        //In the last record we omit the $time argument, this means the slide will be shown until the end of the audio file
    );

    $slideshow->addAudio('audio/lifepath/lifepath-'.$lifePath.'-A.mp3');
    $slideshow->clear()->addSlide();
    $slideshow->setTitle("Life Path for <b>$firstName</b>\n Born \n<b><red>$monthName $dayNum, $yearNum</red></b>.");
    $slideshow->addBirthTiles( $yearNum , $monthNum, $dayNum );


    if ($nameMatch == true ){
        $f = "audio/name-youhave/".$fname."_youhave.mp3";
        $slideshow->addAudio( $f );
        $you = "$firstName, you";
    }else{
        $you = "You";
    }
    //23 seconds
    $slideshow->addAudio('audio/lifepath/lifepath-'.$lifePath.'-B.mp3');
    switch ( $lifePath ) {
        case 1:
            $slideshow->addCenteredTextSet(
                [3.60 + $nameAudioLength,  "$you are a born leader and an absolute authority in your field"],
                [3.667, "Like your Life Path implies, you are destined to be #1."]
            );
            $slideshow->addCenteredTextSet(
                [4.455, "You are ambitious, confident, self-motivated, fiercely independent, "],
                [4.679, "and have a rare talent that is guaranteed to put you in the spotlight at least once in your life."],
                [4.027, "You are very good at getting the ball rolling and initiating new projects, "],
                [3.858, "but tire of routine and highly-detailed tasks quickly."],
                [1.690, "When confronted with obstacles, "],
                [2.584, "your unwavering inner strength and sense of self "],
                [2.902, "acts as a beacon others are inspired to follow."],
                [5.496, "Your assertive nature \nand willingness to do\n“whatever it takes”\nkeeps you ahead of the pack "]
            );
            $slideshow->addCenteredTextSet(
                [2.356, "and is the key\nto your success in life. "],
                [4.674, "While it may often feel like you face more challenges or difficulties in life than others, "],
                [3.217, "it’s only because you’re more ready and able to handle the risk."],
                [3.555, "It’s your job to step up, break away from the status quo, "],
                [1.722, "and inspire those around you. "],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
                );
                break;
        case 2:
            $slideshow->addCenteredTextSet(
                [3.000 + $nameAudioLength, "$you are a sensitive soul with an amazing imagination."],
                [2.644, "You have off-the-charts emotional intelligence,"],
                [2.711, "refined intuition, extreme perceptiveness, "]
                );
            $slideshow->addCenteredTextSet(
                [3.476, "and the ability to truly connect and understand those around you."],
                [2.644, "You’re the world’s best secret-keeper"],
                [2.040, "and your kind and co-operative nature "],
                [2.988, "makes you a fantastic friend, parent, and partner. "],
                [3.394, "While you have the tendency to be a bit of a perfectionist, "],
                [3.164, "it’s only because you sincerely want the best for yourself and others "],
                [2.981, "and see the potential for greatness in everyone you meet."],
                [2.104, "You have the rare gift of persuasion "],
                [2.586, "and can inspire those around you without force. "],
                [2.542, "You’re often accused of being too quiet "],
                [3.508, "but that’s because you spend more time listening than stroking your own ego. "]
                );
            $slideshow->addCenteredTextSet(
                [3.394, "You exhibit a silent yet spiritually-evolved power "],
                [3.458, "that allows you to remain balanced and fair in stressful situations. "],
                [4.949, "You have the innate ability to create harmony, lead with compassion and empathy, "],
                [1.856, "and encourage those around you. "],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 3:
            $slideshow->addCenteredTextSet(
                [3.800 + $nameAudioLength, "$you are chock full of charm, popularity, and wit. "],
                [2.617, "You’re artistic, have unparalleled creativity, "]
                );
            $slideshow->addCenteredTextSet(
                [2.644, "and search for inspiration in everything you do. "],
                [3.499, "You are resilient and willing to step outside your comfort zone "],
                [1.824, "to create the life of your dreams."],
                [4.375, "Your laid back and happy-go-lucky nature makes you very easy to be around. "],
                [3.144, "You’re a warm, generous, and charismatic person… "],
                [3.588, "always willing to inject humor and words of wisdom into any situation. "],
                [3.154, "You’re the life of the party and can always make people laugh. "],
                [4.265, "You believe that life is too short to be wasted in anger or frustration. "],
                [3.216, "While you’re often misjudged as being disorganized "]
                );
            $slideshow->addCenteredTextSet(
                [2.150, "or someone who doesn’t take life seriously enough, "],
                [5.162, "it’s only because you posses an intense desire for joy, personal expression, and adventure "],
                [2.036, "that many people simply don’t understand. "],
                [3.330, "No matter what, continue to share your creative gifts "],
                [2.137, "and passion for life with those around you."],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 4:
            $slideshow->addCenteredTextSet(
                [4.500 + $nameAudioLength, "$you are a natural leader and possess enormous strength, integrity, and discipline."],
                [2.486, "You have a deep understanding of how things work"]
            );
            $slideshow->addCenteredTextSet(
                [4.385, "and the unwavering ability to support yourself and those around you with little effort."],
                [2.499, "Your success in life is not due to luck, "],
                [2.700, "it comes from your honesty and commitment to excellence. "],
                [2.092, "You are reliable, persevering, "],
                [3.521, "and can turn something ordinary into something extraordinary."],
                [2.168, "You’re diligent, organized, "],
                [1.859, "and when it comes to the task at hand, "],
                [1.849, "you get it done no matter what."],
                [1.584, "You are a true survivor "],
                [2.891, "and push through even the biggest obstacles courageously."],
                [2.562, "While you have a tendency to over-work "],
                [1.946, "and can often spread yourself too thin, "]
            );
            $slideshow->addCenteredTextSet(
                [2.350, "it’s only because you’re never willing to give up "],
                [2.238, "and love nothing more than to see results. "],
                [3.350, "You have the rare gift of being able to guide others through adversity "],
                [1.857, "while keeping both feet on the ground. "],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 5:
            $slideshow->addCenteredTextSet(
                [4.025 + $nameAudioLength, "$you love travel, adventure, variety and meeting new people."],
                [2.519, "You possess the curiosity of a cat "]
                );
            $slideshow->addCenteredTextSet(
                [1.935, "and long to experience life to the fullest. "],
                [3.420, "You make friends easily and your personality is magnetic."],
                [3.028, "Unlike most, you thrive during change "],
                [2.588, "and are not easily ruffled in times of uncertainty. "],
                [3.779, "You love to be involved in \n several different projects \n and activities at once "],
                [2.272, "and are always on the look-out for new adventures. "],
                [3.892, "Your flexibility and adaptability are the keys to your success."],
                [2.700, "You crave freedom above all else "],
                [2.632, "and are willing to do whatever it takes to not be tied down."],
                [4.612, "You’re often accused of being too impulsive, extreme, or a “wild child” "]
                );
            $slideshow->addCenteredTextSet(
                [2.756, "but it’s only because you have such a vibrant free-spirit."],
                [3.135, "You’ve likely experienced more in the past 5 years "],
                [2.435, "than many people have in their entire lifetimes. "],
                [3.587, "You have the rare gift of uplifting and motivating others "],
                [2.655, "through your rich experiences and words of wisdom."],
                [NULL, "Contnue to do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 6:
            $slideshow->addCenteredTextSet(
                [4.443 + $nameAudioLength, "$you are sensitive and empathic with the gift of making everyone around you happy! "],
                [3.801, "You are devoted, certain, and in charge in all ways."]
                );
            $slideshow->addCenteredTextSet(
                [3.925, "Responsibility and service are two of your most important qualities. "],
                [3.027, "You are always looking for ways you can support a greater cause "],
                [2.418, "and have the rare ability to comfort those in need."],
                [4.137, "You are intelligent, creative, and naturally very balanced. "],
                [2.781, "People often seek you out for advice and support "],
                [3.318, "and that’s because you provide profound wisdom without judgment."],
                [3.689, "You are often admired and adored which baffles you. "],
                [0.902, "You are humble, "],
                [2.743, "yet carry a strong sense of pride in everything you do."],
                [2.520, "You have the tendency to put others first "]
                );
            $slideshow->addCenteredTextSet(
                [3.106, "which can leave you feeling drained or taken advantage of at times, "],
                [3.828, "but it’s only because you have such fierce loyalty and commitment to those you love. "],
                [3.576, "Continue to guide and support others while loving yourself too "],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 7:
            $slideshow->addCenteredTextSet(
                [2.542 + $nameAudioLength, "$you are mystical, intuitive, and sensitive. "],
                [4.253, "You have a quiet power and garner the utmost respect from those around you. "]
                );
            $slideshow->addCenteredTextSet(
                [3.904, "You have extraordinary wisdom, like you’ve lived a thousand lifetimes, "],
                [3.678, "and seek enlightenment over material achievement."],
                [2.734, "You have a clear and compelling sense of self "],
                [2.352, "and a deep yearning to understand the unknown. "],
                [1.675, "You’re a analytical thinker, "],
                [1.834, "capable of great concentration,"],
                [2.440, "and give practical insight and advice."],
                [3.037, "You enjoy your privacy and prefer to work alone "],
                [4.181, "but have great confidence, wit, and charm which draws people to you. "],
                [1.669, "You’re often the story-teller, "],
                [2.970, "sharing your sage-like wisdom with those around you.  "]
                );
            $slideshow->addCenteredTextSet(
                [3.026, "At times, you’re accused of being a lone wolf, "],
                [2.193, "someone who lives by their own ideas and methods, "],
                [3.026, "but it’s only because you are fascinated by life’s little mysteries  "],
                [2.283, "and are constantly seeking answers."],
                [2.621, "You have the rare gift of using creative insight"],
                [2.047, "to solve even the trickiest problems."],
                [NULL, "Contnue to do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 8:
            $slideshow->addCenteredTextSet(
                [2.126 + $nameAudioLength, "$you are a take-charge \n kind of person."],
                [2.958, "You’re passionate, tough, \n and have tremendous \n inner strength. "],
                [3.003, "You are a born leader and\n  have outstanding charisma"]
                );
            $slideshow->addCenteredTextSet(
                [1.935, "that inspires others \n to take action."],
                [4.466, "Your great judge of character aids you well in attracting the right people to you."],
                [2.575, "Everything you do \n is larger than life. "],
                [1.574, "You are a true visionary "],
                [2.812, "and do whatever it takes to achieve your lofty goals. "],
                [2.030, "You’re willing to take big risks, "],
                [4.548, "and because of that you’re more likely than most to achieve immeasurable rewards. "]
                );
            $slideshow->addCenteredTextSet(
                [2.207, "When you do \n experience a challenge,"],
                [2.183, "you have the guts and resilience to push forward."],
                [2.114, "You’re a true survivor. "],
                [4.421, "While you are often accused of being stubborn, impatient, or anti-authority, "],
                [3.262, "it’s only because you’re more courageous and determined than most "],
                [2.756, "and don’t like \n getting caught up in the \n “little things”. "],
                [2.081, "Keep focused on \n your grand vision "],
                [1.946, "while patiently guiding those around you "],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\n Life Path potential. "]
            );
            break;
        case 9:
            $slideshow->addCenteredTextSet(
                [1.416 + $nameAudioLength, "$you are an <b>old soul</b>."],
                [1.955, "You are wise \n beyond your years "],
                [3.478, "and posses deep \n intelligence, intuition, \n and psychic ability. "],
                [1.957, "You have a great \n sense of <red>knowingness</red>"]
                );
            $slideshow->addCenteredTextSet(
                [2.261, "and tend to predict things \n before they happen. "],
                [3.386, "You’re highly sensitive and \n feel a wide range of emotions "],
                [1.800, "and that’s because, as a 9, "],
                [3.105, "you embody the vibrations \n of <red> all the other numbers</red>. "],
                [3.430, "You experience \n the greatest extremes of \n happiness and sorrow,"],
                [2.880, "yet you always <red> bounce back </red> \n and move on quickly."],
                [1.625, "You seek \n <red> knowledge and growth </red>"],
                [2.438, "and have a strong sense \n of <b>mission</b> in life. "],
                [3.293, "People are naturally \n drawn to your warm \n and welcoming nature. "],
                [3.127, "You’re often accused of being \n a bit of a daydreamer, "],
                [3.950, "but that’s because your \n creativity and wild imagination \n never ceases. "]
                );
            $slideshow->addCenteredTextSet(
                [2.136, "When you are \n dedicated to your goals, "],
                [2.278, "you exhibit a \n <red> strong sense of character.</red> "],
                [1.974, "Continue to \n <red> listen to your intuition </red>"],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 11:
            $slideshow->addCenteredTextSet(
                [3.081 + $nameAudioLength, "$you are probably already \n aware of how <b>unique</b> \n your life path is "],
                [4.892, "because this \n <b>numerological vibration</b> \n can have quite <red>extreme</red> \n and <red>exciting</red> effects."]
                );
            $slideshow->addCenteredTextSet(
                [3.084, "In numerology, \n 11 is a <b>Master Number</b>. "],
                [3.375, "You have unmatched <red>intelligence</red>, <red>intuition</red>, "],
                [2.778, "and <red>energy</red> that flows \n through you effortlessly. "],
                [2.149, "You inspire people \n without even trying "],
                [3.678, "and new ideas, answers, \n and opportunities present \n themselves quickly,"],
                [1.631, "and often by surprise."],
                [4.106, "All of this amounts to \n <b>a great capacity</b> for \n invention and creation. "],
                [2.396, "Whether you’re aware \n of it yet or not,"],
                [2.013, "you have <red>deep psychic ability</red>"],
                [1.642, "and a rare connection to spirit. "],
                [3.769, "You are a beacon of light \n which others naturally follow. "]
                );
            $slideshow->addCenteredTextSet(
                [2.025, "Because of this, \n you likely find that "],
                [3.662, "others often request your support, advice, and direction."],
                [1.610, "You tend to be a bit emotional "],
                [2.434, "but it’s only because \n you are so highly charged "],
                [2.463, "and experience such \n rich psychic connections "],
                [3.138, "that it can be hard \n to process all the \n information you receive."],
                [2.925, "Continue to be open\nto divine inspiration "],
                [1.586, "and guide others\nwith your wisdom "],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 22:
            $slideshow->addCenteredTextSet(
                [3.184 + $nameAudioLength, "$you are probably already \n aware of how unique \n your life path is "],
                [4.892, "because this \n <b>numerological vibration</b> \n can have quite <red>extreme</red> \n and <red>exciting</red> effects."]
                );
            $slideshow->addCenteredTextSet(
                [3.342, "In numerology,\n22 is a <b>Master Number</b>."],
                [2.902, "You are capable of\nbig, BIG things "],
                [2.946, "and probably find yourself\nworking on projects and tasks "],
                [2.982, "that are huge in scope\nor have mass appeal."],
                [2.519, "You are willing to\nwork hard to\nget the job done "],
                [1.473, "and always crave more."],
                [1.946, "The bigger the job, the better! "],
                [3.015, "You’re a great organizer,\nplanner, mover and shaker "],
                [2.069, "that affects the \nlives of many people. "],
                [2.778, "Your <red>charisma</red> evokes the\ncooperation of others, "],
                [1.338, "you don’t need to force it."],
                [0.968, "Because of this, "],
                [4.521, "you likely find that\nothers frequently request\nyour support, advice and direction."]
                );
            $slideshow->addCenteredTextSet(
                [2.745, "You’re often accused of\nbeing a bit of a <red>workaholic</red> "],
                [3.735, "but it’s only because\nyou have an intense desire\nto <red>grow and expand</red>. "],
                [3.453, "You have the ability\nto turn the <red>ordinary</red>\ninto the <red>exceptional</red> "],
                [1.710, "and keep both feet\non the ground, "],
                [2.475, "no matter how high\nyou rise in life. "],
                [NULL, "Continue to do this and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        default:
            throw new exception( "Huh? Unknown life path!");
    }
    
    //75 seconds

    $slideshow->addAudio('audio/expression/subscriber-expression-intro.mp3');
    $slideshow->addCenteredTextSet(
        [3.375, "Next, let’s look at \nwhat is known as your \n “<b><red>Expression</red></b>”"],
        [3.521, "This is another <red> extremely important </red> element in your numerology chart "],
        [2.542, "as it highlights your\n<b>natural talents</b>\n and <b>abilities</b>,"],
        [2.732, "many you likely \n didn’t know you had. "],
        [2.367, "It is often called the \n “<red><b>Destiny Number</b></red>” "]
        );
    $slideshow->addCenteredTextSet(
        [2.403, "because it reveals a great deal about your <b>potential</b>"],
        [2.329, "and what you’re \n <red>meant to accomplish</red> \n in this lifetime."],
        [3.745, "While your Life Path \n is calculated using your \n <red>date of birth</red>, "],
        [4.995, "your Expression is calculated by analyzing the letters of your <red>FULL <b>name</b> at birth</red>. "],
        [ 2.748, "It can be a bit\ntime consuming to do\nthe math by hand," ],
        [  NULL, "so I took the liberty\nof <red>calculating</red> and\n <red>interpreting</red> <b>your</b>\nExpression Number\nfor you." ]
);


$slideshow->clear();

if ($nameMatch == true ){
    $f = "audio/name-youhave/".$fname."_youhave.mp3";
    $slideshow->addAudio( $f );
    $nameAudioLength = $slideshow->getAudioLen();
    $you = "$firstName, you";
}else{
    $nameAudioLength = 0;
    $you = "You";
}

$slideshow->addAudio('audio/expression/expression-'.$expression.'.mp3');  // e.g. ""

$slideshow->addSlide( 7.437 );
$slideshow->setTitle("Numerology\nBirthname Analysis\n for\n<b><red>$fullBirthName</red></b>.\n");
$slideshow->addTiles( $fullBirthName );
//45 seconds
switch ( $expression ) {
    case 1:
        $slideshow->addCenteredTextSet(
            [1.352 + $nameAudioLength,  "<b><red>1</red></b> is the number of a\n<b>natural leader</b>"],
            [1.406,  "You are assertive, ambitious, "],
            [2.155,  "and always ready to answer the call of duty."],
            [3.278,  "Determination and courage are your strongest inner gifts."],
            [2.756,  "You’ve probably found that failure only knocks at your door "],
            [2.351,  "when you don't rely on your own abilities"]
        );
        
        $slideshow->addCenteredTextSet(
            [4.906,  "You achieve success by acting in a bold, forthright, and opportunistic fashion "],
            [1.067,  " – so keep it up."],
            [4.196,  "You’re incredibly confident which can sometimes rub people the wrong way. "],
            [4.635,  "While those with a lower sense-of-self may see you as selfish or egotistical at first"],
            [4.432,  "your unwavering loyalty and level-headedness makes you quick to defuse any tension "],
            [3.009,  "and inspire those around you to step up and succeed."],
            [3.652,  "You understand that a rising tide raises all ships. "],
            [2.945,  "Continue to celebrate and appreciate others’ achievements "]
        );
        
        $slideshow->addCenteredTextSet(
            [ NULL,  "and it is almost guaranteed that you’ll attract enormous success in your life"] );
        break;
    case 2:
        $slideshow->addCenteredTextSet(
            [1.388 + $nameAudioLength,  "<b><red>2</red></b> is the number of\n<b>cooperation</b>"],
            [1.957,  "You are compassionate, diplomatic,"],
            [1.665,  "and an excellent communicator."],
            [2.054,  "You care deeply for those around you."],
            [3.761,  "Your strongest inner gifts are your ability to form powerful partnerships "],
            [2.689,  "and bring balance and harmony to any situation."],
            [3.116,  "You’ve probably found that failure only knocks at your door "]
        );
        
        $slideshow->addCenteredTextSet(
            [3.352,  "when you get too tied-up in other people’s problems or insecurities. "],
            [5.276,  "You achieve great success through common effort and working in peaceful coexistence with your peers"],
            [1.032,  "– so keep it up!"],
            [2.050,  "Because you’re so reliable, "],
            [3.780,  "at times you get frustrated with others when their sense of cooperation slips "],
            [1.575,  "and they leave you hanging."],
            [4.656,  "But, when many others would think it a better idea to give up or “go at it solo”, "],
            [4.613,  "your patience and understanding always puts you back on top of a winning team."],
            [2.713,  "You have a rare gift for bringing out the best in people."],
            [2.551,  "Continue to lead by example and empower others "]
        );
        
        $slideshow->addCenteredTextSet(
            [2.892,  "and it is almost guaranteed that you’ll make positive impressions "],
            [ NULL,  "that will open many doors for you."]
        );
        break;
    case 3:
        $slideshow->addCenteredTextSet(
            [1.680 + $nameAudioLength,  "<b><red>3</red></b> is the number of\n<b>charisma and creativity</b>"],
            [2.790,  "You are fun, spontaneous, and wildly popular."],
            [3.948,  "You effortlessly ignite the spark of enthusiasm and excitement in others,"],
            [1.024,  "and, as a result, "],
            [2.497,  "you earn a great amount of respect and admiration."],
            [2.250,  "This innate gift is the key to your success "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.052,  "– so keep it up!"],
            [2.876,  "You’ve probably found that failure only knocks at your door "],
            [2.224,  "when you lose focus of what YOU want "],
            [1.968,  "or let your spontaneity get the best of you. "],
            [2.790,  "You tend to “fly by the seat of your pants” "],
            [3.667,  "and while others sometimes accuse you of being flaky or unreliable, "],
            [3.386,  "you know the importance of follow-through and commitment."],
            [1.845,  "You have a rare gift of precognition "],
            [2.958,  "and may find that you have flashes about what’s to come. "],
            [2.644,  "This is a tremendous asset that allows you to "],
            [2.498,  "adapt quickly and deeply understand others. "],
            [2.879,  "Continue to bring joy and excitement to those around you "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.348,  "and it is almost guaranteed that"],
            [ NULL,  "you’ll live a prosperous and happy life. "]
        );
        break;
    case 4:
        $slideshow->addCenteredTextSet(
            [1.561 + $nameAudioLength,  "<b><red>4</red></b> is the number of\n<b>patience and stability</b>"],
            [2.640,  "You have a natural ability to keep both feet on the ground "],
            [1.753,  "and which is why others come to you frequently "],
            [1.721,  "seeking support and guidance."],
            [2.363,  "Your strongest inner gift is your ability to "],
            [2.472,  "put your head down and focus on the task at hand. "],
            [1.362,  "You get stuff done, "],
            [1.237,  "and done properly, "]
        );
        
        $slideshow->addCenteredTextSet(
            [2.025,  "which makes you a force to be reckoned with. "],
            [2.587,  "This is most definitely the key to your success "],
            [1.248,  "– so keep it up!"],
            [2.801,  "You’ve probably found that failure only knocks at your door "],
            [1.961,  "when take on too much at once."],
            [2.778,  "You’re often called upon to lead new projects "],
            [1.867,  "and assume positions of responsibility,"],
            [2.651,  "which can leave you feeling limited and overwhelmed,"],
            [3.109,  "especially when others don’t have the same worth ethic you do."],
            [1.956,  "Despite this weight on your shoulders, "],
            [3.408,  "you have tremendous reserves of energy power to draw from. "],
            [2.340,  "Put this energy towards achieving your goals "]
        );
        
        $slideshow->addCenteredTextSet(
            [ NULL,  "and you’ll be unstoppable."]
        );
        break;
    case 5:
        $slideshow->addCenteredTextSet(
            [1.418 + $nameAudioLength,  "<b><red>5</red></b> is the number of\n<b>freedom and variety</b>"],
            [2.453,  "You’re extremely\neasy-going and adaptable."],
            [1.442,  "You love to stay\nahead of the curve "],
            [2.066,  "and are always asking\n<red>“what’s next?!”</red>"],
            [1.530,  "You love to travel, "],
            [1.170,  "live in the fast lane "],
            [2.103,  "and handle quick\nchanges with grace."],
            [2.407,  "Your greatest gift is\nyour ability to multi-task "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.528,  "without breaking a sweat"],
            [2.758,  "You’ve probably found\nthat failure only\nknocks at your door "],
            [2.372,  "when you find yourself\nbored or unchallenged."],
            [2.160,  "Your versatility and\nquick-start personality "],
            [1.316,  "are the keys to your success "],
            [1.507,  " – so keep it up!"],
            [3.712,  "Your love of constantly\nchanging circumstances\nand unusual happenings "],
            [2.317,  "will keep your life\ncolorful and interesting. "],
            [1.788,  "While those more\nrigid than you "],
            [3.186,  "may question your\ncommitments or see you as\nunstable nor unreliable, "],
            [2.810,  "you know the importance of\nplanning and goal-setting."],
            [2.531,  "You have more spice in\nyour life than most. "],
            [3.071,  "Continue to focus\non building an\nempowering routine, "]
        );
        
        $slideshow->addCenteredTextSet(
            [3.060,  "letting your intuition\nto guide you and\nhonoring your commitments "],
            [ NULL,  "and you’ll have more\nsuccess and fun than\nyou thought possible."]
        );
        break;
    case 6:
        $slideshow->addCenteredTextSet(
            [1.680 + $nameAudioLength,  "<b><red>6</red></b> is the number of\n<b>contribution and reliability</b>"],
            [2.418,  "You are\n<red> devoted and generous </red>\nin all that you do."],
            [2.767,  "Your sense of responsibility\nis rarely outmatched, "],
            [2.103,  "and it shows clearly\nin your love of others "],
            [1.743,  "and willingness to do\nwhatever it takes "],
            [1.361,  "to help someone in need"],
            [2.080,  "whether it be a friend\nor complete stranger."]
        );
        
        $slideshow->addCenteredTextSet(
            [2.373,  "Your <red>greatest inner gift</red>\nis your ability to  "],
            [2.416,  "gain an unwavering sense\nof trust from others."],
            [2.365,  "This dependability and\nstrength of character "],
            [1.203,  "are the keys to your success "],
            [1.215,  "– so keep it up!"],
            [2.791,  "You’ve probably found\nthat failure only\nknocks at your door "],
            [1.955,  "when you undermine\nyour own integrity "],
            [2.441,  "by sacrificing too much\nfor the benefit of others."],
            [1.868,  "Because of your\ndependable nature, "],
            [2.001,  "you tend to attract\ndependent people"],               // AUDIO SAYS **DIFFERENT** PEOPLE
            [1.583,  "in your personal\nand professional life,"],
            [1.555,  "so keep a watchful eye."],
            [3.892,  "Set boundaries and\navoid absorbing others’\nproblems as your own."],
            [1.417,  "You are full of love."],
            [2.104,  "Continue to\nfocus on your own\ngoals and ambitions, "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.203,  "as well as those of others"],
            [1.285,  "and that love will multiply "],
            [ NULL,  "and take your success\nto a whole new level"]
        );
        break;
    case 7:
        $slideshow->addCenteredTextSet(
            [1.180 + $nameAudioLength,  "<b><red>7</red></b> is the number of\n<b>spirit</b>"],
            [2.127,  "You have the most\nmystical expression\nof them all!"],
            [2.642,  "You are a truth-seeker\nand tend to delve deeply "],
            [2.058,  "into the secrets of\nnature and the\nhuman mind, "],
            [3.129,  "either through science or\nby more esoteric methods."],
            [2.101,  "You’re creative and philosophical "],
            [2.461,  "which make you a natural\nvisionary and teacher."]
        );
        
        $slideshow->addCenteredTextSet(
            [1.602,  "Your greatest internal gift "],
            [2.327,  "is the ability to\nsee the “big picture”"],
            [1.700,  "while staying true\nto your purpose. "],
            [2.596,  "Your wisdom and presence\nare the keys to your success "],
            [1.091,  " – so keep it up!"],
            [2.520,  "You’ve probably found\nthat failure only\nknocks at your door "],
            [1.361,  "when you spend too much time "],
            [1.655,  "focusing on trivial details."],
            [2.631,  "Others often see you\nas too philosophical "],
            [1.658,  "or intellectually superior."],
            [3.712,  "While this can make the\nsocial aspects of life\na bit difficult for you, "],
            [1.672,  "you always make a\nconcerted effort "],
            [2.234,  "ally with others who\nare different from you "],
            [2.322,  "to gain valuable\ninsight and experience."],
            [3.428,  "This garners you\nmuch admiration and respect\nfrom your peers."]
        );
        
        $slideshow->addCenteredTextSet(
            [2.084,  "You have a rare gift\nof teaching others "],
            [2.126,  "in a very positive\nand uplifting way."],
            [1.610,  "Continue to seek answers "],
            [3.430,  "and keep your materialistic\nand spiritual viewpoints\nin harmony "],
            [1.124,  "and you’ll be able to achieve"],
            [ NULL,  "anything you set your mind to."]
        );
        break;
    case 8:
        $slideshow->addCenteredTextSet(
            [0.680 + $nameAudioLength,  "<b><red>8</red></b> is the number of\n<b>achievement</b>"],
            [1.352,  "You’re likely to achieve success"],
            [1.732,  "more easily than anyone else."],
            [2.767,  "You’re a managerial and\norganizational genius "],
            [2.351,  "with strong intellect\nand determination."],
            [1.858,  "Your greatest gift\nis your confidence "],
            [2.124,  "and ability to move\nthe needle quickly."],
            [2.688,  "You’ve probably found\nthat failure only\nknocks at your door "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.923,  "when others\nget in the way\nof your objectives."],
            [2.724,  "People often look to you for motivation and direction "],
            [1.810,  "and these are\nthe keys to your\nown success "],
            [1.113,  " – so keep it up!"],
            [1.915,  "Because you move\nfaster than most,"],
            [2.719,  "you get easily frustrated\nby delays or inaction "],
            [2.654,  "and often take on\nmore work in order\nto compensate."],
            [1.766,  "In order to avoid stress, "],
            [1.293,  "remember to slow down "],
            [2.137,  "take a step back\nfrom time to time. "],
            [2.092,  "Funnel that abundant\nenergy into yourself "],
            [1.045,  "and your relationships "],
            [2.644,  "and watch the tension\nand resistance fade away."],
            [2.846,  "You have a rare gift\nof achieving\noutstanding results."],
            [2.497,  "Continue to temper your\ndiscipline and ambition"]
        );
        
        $slideshow->addCenteredTextSet(
            [1.473,  "with patience and compassion "],
            [ NULL,  "and you’ll experience thrill,\nhappiness, and success\nin all you do."]

        );
        break;
    case 9:
        $slideshow->addCenteredTextSet(
            [1.180+$nameAudioLength,  "<b><red>9</red></b> is the number of\n<b>quiet power</b>"],
            [2.929,  "You’re independent, compassionate,\nand highly sensitive."],
            [1.627,  "While you have strong emotions, "],
            [2.418,  "you have more resilience\nand tolerance than most."],
            [2.295,  "You see disappointment\nas opportunity "],
            [1.586,  "and challenge as adventure "],
            [1.046,  "and, because of this,"],
            [1.955,  "you’re always progressing\nand expanding. "]
        );
        
        $slideshow->addCenteredTextSet(
            [3.827,  "Your greatest gift is\nyour ability to recover\nquickly from setbacks."],
            [1.800,  "Your “get up and\ntry again” attitude "],
            [1.315,  "the key to your success "],
            [1.102,  " – so keep it up!"],
            [2.722,  "You’ve probably found\nthat failure only\nknocks at your door"],
            [1.968,  "when you focus too much\ntime and energy "],
            [2.250,  "on obtaining material\nwealth and power "],
            [3.453,  "and that’s because you’re\nmore spiritually-evolved\nthan most."],
            [3.028,  "You believe that\nwinning is about\ncoming out <red>right</red> "],
            [1.715,  "rather than\ncoming out on top."],
            [3.706,  "You have a rare gift\nof unmatched compassion\nand wisdom. "],
            [1.439,  "Continue to cultivate this "],
            [1.756,  "and channel your power\ninto helping others "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.573,  "and you’ll bring\njoy and success "],
            [1.766,  "into the lives of\neveryone around you, "],
            [ NULL,  "including yourself."]
        );
        break;
    case 11:
        $slideshow->addCenteredTextSet(
            [2.080 + $nameAudioLength,  "<b><red>11</red></b> is the master number of\n<b>inspiration and intuition</b>"],
            [1.080,  "You are a visionary "],
            [1.327,  "and often see the outcome "],
            [1.863,  "of circumstances\n<red>before</red> they happen."],
            [1.759,  "This makes you highly creative "],
            [2.711,  "and someone who always thinks outside of the box."],
            [2.778,  "You’ve probably found that failure only knocks at your door "],
            [1.137,  "when you feel constrained "]
        );
        
        $slideshow->addCenteredTextSet(
            [2.001,  "or stunted in your creativity."],
            [1.406,  "A free spirit by nature,"],
            [1.968,  "you often let your\n<red>heart</red> guide you "],
            [1.091,  "in your decision-making."],
            [1.733,  "Your greatest gift\nis your <red>intuition</red> "],
            [1.247,  "and the way you use it "],
            [1.687,  "to <b>inspire</b> and\n<b>empower</b> others."],
            [2.462,  "This unique perspective\nand open expression"],
            [1.412,  "is the key to your success "],
            [1.244,  "– so keep it up!"],
            [2.021,  "Your strong character\nand individuality "],
            [1.894,  "can be hard for\nothers to understand."],
            [2.800,  "While this can make\nrelationships and\ncollaboration difficult, "],
            [1.496,  " you are always\n<red>open to learning</red> "],
            [0.990,  "from those around you -"],
            [2.306,  "– even if they seem\nboring, rigid, or mundane - "],
            [1.833,  "which garners you\nmuch admiration "]
        );
        
        $slideshow->addCenteredTextSet(
            [1.462,  "and respect\nfrom your peers."],
            [3.015,  "Continue to be the\n<red>inspiring visionary</red> you are"],
            [1.709,  "and account for the\nfact that others might"],
            [1.823,  "“just see it differently”."],
            [2.722,  "This harmony will\ninspire more <red>creativity</red> "],
            [1.001,  "in those around you "],
            [2.621,  "and create more <red>connection</red>,\n<red>happiness</red>, and <red>success</red> "],
            [ NULL,  "in all you do."]
        );
        break;
    case 22:
        $slideshow->addCenteredTextSet(
            [1.380 + $nameAudioLength,  "<b><red>22</red></b> is the <b>master number</b>\n of <b>creation</b>"],
            [2.070,  "It is likely that you make <red>big plans</red> "],
            [1.812,  "and always have the\nbig picture in mind."],
            [2.204,  "You have grandiose goals\nand are interested in"],
            [2.340,  "building things that\n“move the world”. "],
            [3.276,  "Your 10,000-foot view\nis awe-inspiring "],
            [1.854,  "and you gain energy\nfrom the momentum"]
        );
        
        $slideshow->addCenteredTextSet(
            [1.847,  "that’s created when\nstarting something new! "],
            [2.314,  "Your greatest gift\nis the ability to"],
            [1.586,  "see the potential\nin everything."],
            [1.327,  "Your energy and enthusiasm "],
            [1.529,  "are the keys to your success "],
            [1.158,  "– so keep it up!"],
            [2.760,  "You’ve probably found\nthat failure only\nknocks at your door "],
            [2.380,  "when your unshakeable focus\non the grand vision "],
            [2.002,  "makes you lose sight\nof the smaller details "],
            [1.473,  "critical to your success."],
            [1.999,  "Be sure to prioritize\nand organize "],
            [2.239,  " to avoid “biting off\nmore than you can chew” "],
            [2.632,  "and use your enthusiasm\nto attract people "],
            [2.306,  "who help you achieve\nyour lofty goals."],
            [2.171,  "You have a rare gift\nof motivating"]
        );
        
        $slideshow->addCenteredTextSet(
            [1.759,  "and inspiring others\nto take action"],
            [1.930,  "Continue to\nreach for the stars "],
            [1.585,  "while uplifting\nthose around you "],
            [ NULL,  "and you’ll be a force\nto be reckoned with."]
        );
        break;
    default:
        throw new exception( "Huh? Unknown Expression!");
}

endOfExpression:



// if ($nameMatch == true )
// {
//     $f = "audio/name-youhave/".$fname."_youhave.mp3";
//     $slideshow->addAudio( $f );
//     $nameAudioLength = $slideshow->getAudioLen();
//     $please = "$firstName, please";
// }else{
//     $please = "Please";
//     $nameAudioLength = 0;
// }
// 
// $slideshow->addAudio('audio/soulurge/subscriber-soulurge-ask.mp3');
// 
// $slideshow->addCenteredTextSet(
// //        [2.000 + $nameAudioLength, "$please know that there is still SO much left"],
//     [2.346 + $nameAudioLength,  "$please know that there is still SO much left"],
//     [2.725, "to explore in your unique Numerology Chart..."],
//     [1.177, "And if you’ll allow me,"],
//     [1.754, "I’d like to give you\neven <red>more</red> insight"],
//     [2.463, "into your <b>life</b>,\n <b>relationships</b>, and\n<b>true purpose</b>"],
//     [2.769, "by analyzing your\n<red><b>Soul Urge Number</b></red>."],
//     [1.743, "Your Soul Urge Number,"],
//     [2.406, "also called your\n<red><b>Heart’s Desire</b></red> Number, "],
//     [1.878, "represents the <b>inner you</b>. "],
//     [2.161, "It exposes your\n<b>hidden motivations</b>, "],
//     [1.810, "<b>deepest cravings</b>\nand <b>urges</b>,"],
//     [1.417, "<b>likes</b> and <b>dislikes</b>."],
//     [1.631, "It reveals the <b>true intention</b> "],
//     [2.239, "behind most of your\n<red>actions</red> and <red>decisions</red>."],
//     [0.900, "In just a minute,"],
//     [2.933, "you’ll discover your\n<b>Soul Urge Number</b>\nand meaning."]
// );
// 
// $slideshow->addCenteredTextSet(
//     [0.800, "But first, "],
//     [3.247, "to make sure\nthis reading is as\n<red>customized</red> and <red>accurate</red>\nas possible"],
//     [1.704, "to your current life circumstances."]
// );
// 
// $slideshow->addCallback('showForm');
// 
// $slideshow->addCenteredTextSet(
//     [1.863, "I need just a bit more information from you."],
//     [2.784,  "Please go ahead and\nenter it now below." ]
// );
// 
// $slideshow->addAudio('audio/static/subscriber-fb-share.mp3');
// 
// $slideshow->addCenteredTextSet(
//     [1.576, "Also, before you continue,"],
//     [2.160, "I have a\n<i>very quick favor</i>\nto ask you… "],
//     [3.373, "If you’re finding this\nnumerology reading\nto be of any\n<b>value</b> to you, "],
//     [3.892, "please take a second\nto <red>click on the blue\nFacebook ‘Share’\nbutton</red> below."],
//     [2.198, "This will give\nyour Facebook friends\nthe opportunity"],
//     [4.800, "to explore <i>their</i>\nhidden personality traits\nand life potential\nwith a free\nnumerology reading,"],
//     [1.463, "just like you\nare doing now..."],
//     [3.160, "AND it will help us\n<red>keep</red> this service\n<b>free of charge</b>."],
//     [3.798, "Don’t worry – we won’t\nshare your date of birth\nor any other personal\ninformation…"],
//     [1.881, "and you won’t\nleave this page."],
//     [3.720, "When you click\n“Share” below, a\nnew Facebook window\nwill open. "],
//     [3.944, "Simply hit the\n“Share Link” button\ninside that window\nand there you have it!"],
//     [2.064, "Your Facebook friends\nwill be <b>blown away</b>..."],
//     [3.696, "and you’ll be right back\nhere where you left off\nin a few seconds flat."],
//     [3.480, "Then, please\ndouble-check that\nthe information you\nentered is accurate,"],
//     [2.943, "then click the\n“Continue with my\nFree Reading”\nbutton "],
//     [NULL, "to dive even\n<b>deeper</b> into your\nnumerology chart."]
// );
// 
// 
//     //We finish with slideshow content, next compile it
// 
//     $compiledSlideshowPath = $slideshow->compile();
// 
// 
//     $form = "freevideo/subscriber-lifepath-expression.form.inc.php";
//     $page_title = "MeSL - Life Path test";
//     $slideshowid = $slideshow->getID();

    $nameMatch = file_exists("audio/hi-name/hi-$fname.mp3");
    include "freevideo/soulurge/subscriber-soulurge-$soulurgeNumbers.php";
    include "freevideo/soulurge/subscriber-soulurge-outro.php";
    $age = floor(((int)date("Y")-(int)$yearNum) / 10)*10;
    if ($age<20) { $age = 'college'; }
    if ($age>60){ $age = 60; }
    $file = "$age-" . ($gender == 'male' ? 'm' : 'f');

    if($age !== 'college')
    {
        $relationshipStatus = 's';
        if($relationship == 'married' || $relationship == 'engaged')
        {
            $relationshipStatus = 'm';
        }

        $file .= "-$relationshipStatus";
    }

    include "freevideo/age-gender-relationship/$file.php";
    include "freevideo/soulurge/subscriber-soulurge-close.php";

    $slideshow->addCallback('showForm');
    $compiledSlideshowPath = $slideshow->compile();
    $slideshowid = $slideshow->getID();

    include "freevideo/player1.inc.php";
    //header("Location: demoplayer.html#!".$slideshow->getID()."/$dayNum/$monthNum/$yearNum/$firstName");
?>

