<?php

require_once("classes/Google/autoload.php");
/**
 * Connect to Google Cloud Storage API
 */
$client = new Google_Client();
$client->setApplicationName("GCS Upload");

// $stored_access_token - your cached oauth access token 
if( $stored_access_token ) {
	$client->setAccessToken( $stored_access_token );
}

$credential = new Google_Auth_AssertionCredentials(
					"numerologist-888@appspot.gserviceaccount.com",
					['https://www.googleapis.com/auth/devstorage.read_write'],
					file_get_contents("/classes/Google/Keys/Numerologist-694a5b5290ea.p12")
				);

$client->setAssertionCredentials($credential);
if($client->getAuth()->isAccessTokenExpired()) {
	$client->getAuth()->refreshTokenWithAssertion($credential);
	// Cache the access token however you choose, getting the access token with $client->getAccessToken()
}

/**
 * Upload a file to google cloud storage
 */
$storage = new Google_Service_Storage($client);
$projectId = 'numerologist-888';
$filename = "logthis.txt";

$ownerAccess = new \Google_Service_Storage_ObjectAccessControl();
$ownerAccess->setEntity('project-owners-' . $projectId);
$ownerAccess->setRole('OWNER');

// this access control is for public access
$readerAccess = new \Google_Service_Storage_ObjectAccessControl();
$readerAccess->setEntity('allUsers');
$readerAccess->setRole('READER');

$obj = new \Google_Service_Storage_StorageObject();
$obj->setName($filename);
$obj->setAcl([$ownerAccess, $readerAccess]);

$storage->objects->insert(
    'numerologist-888.appspot.com',
    $obj,
    [
        'data'       => file_get_contents($filename),
        'uploadType' => 'media',
        'mimeType' => 'audio/mpeg'
    ]
);

echo "Completed";