<?php

  include 'vendor/autoload.php';
  require_once "classes/autoload.php";
  require_once "classes/Numerology.class.php";

  

  $nameExist = $nameSoMatch = $firstName = $answers = false;
  $variants = array('a', 'b', 'c', 'd');
  
  if(isset($_GET['q']) && !empty($_GET['q'])){
    //split ansers to letters
    $answers = str_split($_GET['q']);
    if(count($answers) == 7){//if there is exactly 7 letters
      foreach ($answers as $key => $answer)
        if(!in_array($answer, $variants))// if answer has wrong letter
          $answers = false;
    }
    else
      $answers = false;

    //count each letter in answers
    $counts = array_count_values(array_slice($answers, 0, 6));
    //define mostly combination
    $mostly = ( ($counts['a'] + $counts['b']) < 4 ) ? 'AB' : 'CD'; 

  }
  
  if(isset($_GET['name']) && !empty($_GET['name'])){
    $firstName = ucfirst($_GET['name']);
    $fname = strtolower( $firstName );
    $nameExist  = file_exists("audio/hi-name/hi-$fname.mp3");
    $nameSoMatch = file_exists("audio/name-so/so_$fname.mp3");
  }


  if(is_array($answers)){

    $slideshow = new JsSlideshow("images/bg_light.jpg", 640, 480);
  
   
    if($nameExist){
      $slideshow->addAudio("audio/hi-name/hi-$fname.mp3");
      $slideshow->addCenteredTextSet([NULL, "Hi $firstName..."]);
    }

    $slideshow->addAudio("audio/manifestation/Begin.mp3");
    $slideshow->addCenteredTextSet(
      [2.318, "Congratulations for completing our short quiz,"],
      [3.500, "designed to show you exactly what is energetically holding you back"],
      [NULL, "from attracting all of the prosperity, love, happiness and abundance that you deserve."]
    );

    #elseif( mostlyAB )
    if($mostly == 'AB'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/mostlyAB_1.mp3");
      $slideshow->addCenteredTextSet(
        [2.100, "$firstName,<br>the very first thing I notice"],
        [NULL, "is that you seem to have hit a roadblock on your journey to ultimate life success!"]
      );
    }

    #elseif( mostlyCD )
    if($mostly == 'CD'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/mostlyCD_1.mp3");
      $slideshow->addCenteredTextSet(
        [1.600, "$firstName,<br>the very first thing I notice"],
        [4.940, "is that you are on the right track to manifesting ultimate life success..."],
        [NULL, "and yet, there is one vital ingredient you are missing!"]
      );
    }

    #if(Q1==”a”)
    if($answers[0] == 'a'){
      $slideshow->addAudio("audio/manifestation/Q1_a.mp3");
      $slideshow->addCenteredTextSet(
        [1.853, "Looking at your responses,"],
        [3.395, "it seems apparent the area of your life you most need to improve right now "],
        [1.934, "is that of your personal finances."],
        [3.179, "This is understandable; almost everyone wants to eliminate debt, "],
        [3.263, "manifest more money, and live a life of financial abundance..."],
        [NULL, "and fortunately, the<br><b>Law Of Attraction</b><br>can help get you there."]
      );
    }

    #if(Q1==”b”)
    if($answers[0] == 'b'){
      $slideshow->addAudio("audio/manifestation/Q1_b.mp3");
      $slideshow->addCenteredTextSet(
        [2.055, "Looking at your responses,"],
        [3.847, "it seems apparent the area of your life you most need to improve right now"],
        [1.873, "is that of your health and wellness. "],
        [1.401, "This is understandable;"],
        [3.710, "almost everyone wants the fit, healthy, and attractive body they deserve..."],
        [NULL, "and fortunately, the<br>Law Of Attraction<br>can help get you there."]
      );
    }

    #if(Q1==”c”)
    if($answers[0] == 'c'){
      $slideshow->addAudio("audio/manifestation/Q1_c.mp3");
      $slideshow->addCenteredTextSet(
        [1.993, "Looking at your responses,"],
        [3.600, "it seems apparent the area of your life you most need to improve right now"],
        [2.458, "is that of your personal relationships."],
        [1.311, "This is understandable;"],
        [2.506, "almost everyone wants a life filled with close, "],
        [1.803, "fulfilling, and loving relationships..."],
        [NULL, "and fortunately, the<br>Law Of Attraction<br>can help get you there."]
      );
    }

    #if(Q1==”d”)
    if($answers[0] == 'd'){
      $slideshow->addAudio("audio/manifestation/Q1_d.mp3");
      $slideshow->addCenteredTextSet(
        [2.105, "Looking at your responses,"],
        [3.782, "it seems apparent the area of your life you most need to improve right now"],
        [2.291, "is that of your life satisfaction."],
        [1.391, "This is understandable;"],
        [3.330, "almost everyone wants a life of happiness and personal fulfillment..."],
        [NULL, "and fortunately, the<br>Law Of Attraction<br>can help get you there."]
      );
    }

    #if( mostlyAB )
    if($mostly == 'AB'){
      $slideshow->addAudio("audio/manifestation/mostlyAB_2.mp3");
      $slideshow->addCenteredTextSet(
        [3.449, "The good news is that despite the way things currently feel,"],
        [4.233, "you CAN lead a happy, abundant and richly successful life..."],
        [1.606, "However, right now, "],
        [3.951, "your results show that you are living out of alignment with the life you truly desire."],
        [3.031, "Now, please don’t panic..."],
        [2.637, "because firstly, it’s not your fault..."],
        [3.110, "there are many reasons why someone may be unintentionally attracting"],
        [2.550, "the wrong things into their life"],
        [2.083, "(it’s all about the type of energy you are giving off)..."],
        [1.416, "And secondly,"],
        [3.742, "there IS something you can do about it, which we’ll get to very soon."],
        [3.396, "But first, let me give you a detailed breakdown of your results, "],
        [NULL, "and show you how just knowing these results can help turn your life around..."]
      );
    }

    #if( mostlyCD )
    if($mostly == 'CD'){
      $slideshow->addAudio("audio/manifestation/mostlyCD_2.mp3");
      $slideshow->addCenteredTextSet(
        [2.572, "Right now, your results show"],
        [2.895, "that you are on the right track to manifesting the life of your dreams..."],
        [1.861, "you are so close to abundance! "],
        [4.668, "Very soon, I am going to show you how taking just one more tiny little step"],
        [2.375, "will get you over that finish line..."],
        [3.047, "But first, let me give you a detailed breakdown of your results, "],
        [2.147, "and show you how just knowing these results "],
        [NULL, "can help take your life to the next level..."]
      );
    }

    #if(Q2==”a”)
    if($answers[1] == 'a'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q2_a.mp3");
      $slideshow->addCenteredTextSet(
        [0.400, "$firstName, right now,"],
        [2.786, "negative thoughts and feelings about your life are preventing you"],
        [1.424, " from getting to where you want to be."],
        [2.367, "To manifest the positive changes you deserve,"],
        [4.369, "your first step is to work on building on your <b>self-love and acceptance</b>."],
        [NULL, "Being happy within yourself is crucial for attracting success and abundance."]
      );
    }

    #if(Q2==”b”)
    if($answers[1] == 'b'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q2_a.mp3");
      $slideshow->addCenteredTextSet(
        [0.400, "$firstName, right now,"],
        [2.786, "negative thoughts and feelings about your life are preventing you"],
        [1.424, " from getting to where you want to be."],
        [2.367, "To manifest the positive changes you deserve,"],
        [4.369, "your first step is to work on building on your <b>self-love and acceptance</b>."],
        [NULL, "Being happy within yourself is crucial for attracting success and abundance."]
      );
    }

    #if(Q2==”c”)
    if($answers[1] == 'c'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q2_c.mp3");
      $slideshow->addCenteredTextSet(
        [1.100, "$firstName, even though you would like change,"],
        [3.373, "you are content with your life right now and grateful for what you have."],
        [NULL, "This is a vital part of the ‘success mindset’."]
      );
    }

    #if(Q2==”d”)
    if($answers[1] == 'd'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q2_d.mp3");
      $slideshow->addCenteredTextSet(
        [4.300, "$firstName, you have a true abundance mindset - although you want change,"],
        [2.088, "you are happy and at peace with your life right now."],
        [NULL, "Your positive energy will help you to attract what you desire in life."]
      );
    }

    #if(Q3==”a” or Q3==”b”)
    if($answers[2] == 'a' || $answers[2] == 'b'){
      $slideshow->addAudio("audio/manifestation/Q3_a_b.mp3");
      $slideshow->addCenteredTextSet(
        [4.760, "You seem to find it hard to picture yourself making positive changes in your life..."],
        [3.732, "which indicates that <b>limiting beliefs</b> are holding you back"],
        [1.274, "from getting what you want. "],
        [3.453, "Rather than saying to yourself “I’m never going to achieve that”,"],
        [NULL, "try repeating to yourself just the opposite - “I WILL achieve that”."]
      );
    }

    #if(Q3==”c”)
    if($answers[2] == 'c'){
      $slideshow->addAudio("audio/manifestation/Q3_c.mp3");
      $slideshow->addCenteredTextSet(
        [3.543, "You can picture yourself living exactly the life you want"],
        [2.481, "which means you are already over halfway there!"],
        [2.879, "Try to strengthen this vision by imagining yourself"],
        [2.058, "ALREADY having what you want..."],
        [1.000, "imagine just how good it would feel,"],
        [NULL, "and remind yourself of this every day."]
      );
    }    

    #if(Q3==”d”)
    if($answers[2] == 'd'){
      $slideshow->addAudio("audio/manifestation/Q3_d.mp3");
      $slideshow->addCenteredTextSet(
        [2.472, "When it comes to living the life you want,"],
        [3.371, "your strong visualization skills will make it even easier for you"],
        [NULL, "to make your desires become your reality."]
      );
    }

    #if(Q4==”a” or Q4==”b”)
    if($answers[3] == 'a' || $answers[3] == 'b'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q4_a_b.mp3");
      $slideshow->addCenteredTextSet(
        [2.300, "$firstName, One of the biggest things holding you back right now"],
        [2.313, "is the belief that manifesting what you want "],
        [2.755, "will be ‘hard’, ‘scary’ and ‘difficult’."],
        [0.911, "Remember, "],
        [NULL, "with selfbelief, resilience and a positive mindset, anything is possible."]
      );
    }

    #if(Q4==”c”)
    if($answers[3] == 'c'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q4_c.mp3");
      $slideshow->addCenteredTextSet(
        [2.790, "$firstName, You know what you want and how you can get there,"],
        [3.681, "however sometimes little doubts pop into your head that hinder your progress."],
        [NULL, "Believe in yourself and don’t be afraid to take action to get what you want."]
      );
    }

    #if(Q4==”d”)
    if($answers[3] == 'd'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q4_d.mp3");
      $slideshow->addCenteredTextSet(
        [2.950, "$firstName, Your positive mindset and strong self-belief"],
        [2.423, "will give you the strength and energy you need"],
        [NULL, "to achieve everything you want, no matter how long it takes."]
      );
    }

    #if(Q5==”a”)
    if($answers[4] == 'a'){
      $slideshow->addAudio("audio/manifestation/Q5_a.mp3");
      $slideshow->addCenteredTextSet(
        [3.329, "You indicated that bad things keep happening in your life..."],
        [1.641, "but here’s the big question:"],
        [4.428, "Is your subconscious mind LETTING these bad things happen to you?"],
        [3.228, "The truth is, you have the most control over your life..."],
        [NULL, "and you can CHOOSE to be wealthy, successful, happy and abundant."]
      );
    }

    #if(Q5==”b”)
    if($answers[4] == 'b'){
      $slideshow->addAudio("audio/manifestation/Q5_b.mp3");
      $slideshow->addCenteredTextSet(
        [3.866, "You indicated that abundance and success does not come naturally to you..."],
        [1.674, "but here’s the big question:"],
        [3.429, "Is believing that you have to ‘work hard’ to achieve success"],
        [3.719, "actually the one thing that is holding you BACK from what you desire?"],
        [NULL, "Remember, you are creating your own reality."]
      );
    }

    #if(Q5==”c”)
    if($answers[4] == 'c'){
      $slideshow->addAudio("audio/manifestation/Q5_c.mp3");
      $slideshow->addCenteredTextSet(
        [2.699, "You know that you can achieve great things,"],
        [1.858, "and are on your way to making it happen."],
        [4.125, "Just remember that you don’t always need to over-work yourself to get there..."],
        [2.349, "long as you have a burning desire for what you want"],
        [2.306, "and a strong belief that you can achieve it,"],
        [NULL, "things should fall into place when the time is right."]
      );
    }

    #if(Q5==”d”)
    if($answers[4] == 'd'){
      $slideshow->addAudio("audio/manifestation/Q5_d.mp3");
      $slideshow->addCenteredTextSet(
        [4.400, "You have great self-belief and are fully aware of your own power"],
        [1.537, "when it comes to choosing the life you want..."],
        [1.224, "And as a result,"],
        [NULL, "abundance, success and joy naturally flows towards you."]
      );
    }

    #if(Q6==”a”)
    if($answers[5] == 'a'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q6_a.mp3");
      $slideshow->addCenteredTextSet(
        [3.400, "$firstName, it seems you may be lacking direction and goals in your life right now."],
        [3.893, "Until you have developed a clear vision of the life you want for your future "],
        [1.962, "(that sparks a lot of excitement inside you),"],
        [NULL, "you’ll find it difficult to get what you desire."]
      );
    }

    #if(Q6==”b”)
    if($answers[5] == 'b'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q6_b.mp3");
      $slideshow->addCenteredTextSet(
        [2.300, "$firstName, your tendency to get stuck in the past"],
        [2.340, "may be preventing you from attracting the future you want."],
        [3.188, "Remember, what is in the past is in the past,"],
        [3.532, "and no matter how much you may want to you can’t change it."],
        [NULL, "However, you CAN take control of your future and make the most of it."]
      );
    }

    #if(Q6==”c”)
    if($answers[5] == 'c'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q6_c.mp3");
      $slideshow->addCenteredTextSet(
        [2.803, "$firstName, it seems you are lacking a little direction in your life."],
        [3.254, "Before you can manifest effectively, you need a vivid,"],
        [3.021, "clear image in your mind of exactly what you want."],
        [2.063, "It’s important to follow your heart"],
        [NULL, "and find out exactly what ignites that fire of passion inside you."]
      );
    }

    #if(Q6==”d”)
    if($answers[5] == 'd'){
      if($nameSoMatch)
        $slideshow->addAudio("audio/name-so/so_$fname.mp3");
      $slideshow->addAudio("audio/manifestation/Q6_d.mp3");
      $slideshow->addCenteredTextSet(
        [2.500, "$firstName, you are strongly aware of what you want in life,"],
        [2.893, "and, most importantly, you have the belief, determination"],
        [NULL, "and fire in your belly to get it."]
      );
    }

    #if(Q7==”a”)
    if($answers[6] == 'a'){
      $slideshow->addAudio("audio/manifestation/Q7_a.mp3");
      $slideshow->addCenteredTextSet(
        [3.208, "Sometimes doubt and a lack of self-belief"],
        [3.011, "is stopping you from taking action towards what you want."],
        [2.075, "The next time you have a decision to make, "],
        [2.383, "ignore that doubtful voice in the back of your head"],
        [NULL, "and go with what your heart is telling you."]
      );
    }

    #if(Q7==”b”)
    if($answers[6] == 'b'){
      $slideshow->addAudio("audio/manifestation/Q7_b.mp3");
      $slideshow->addCenteredTextSet(
        [3.554, "Self-doubt is holding you back from manifesting what you desire."],
        [2.798, "If you are constantly fearful that you will fail,"],
        [0.941, "chances are,"],
        [NULL, "there will always be resistance between you and what you want."]
      );
    }

    #if(Q7==”c”)
    if($answers[6] == 'c'){
      $slideshow->addAudio("audio/manifestation/Q7_c.mp3");
      $slideshow->addCenteredTextSet(
      [1.232, "Just remember,"],
      [3.951, "effective manifestation does not require you to justify your desires or"],
      [1.391, "‘weigh up’ options."],
      [3.657, "It’s vital that you allow yourself to follow your gut instinct"],
      [NULL, "and commit to what you want with 100% certainty."]
      );
    }

    #if(Q7==”d”)
    if($answers[6] == 'd'){
      $slideshow->addAudio("audio/manifestation/Q7_d.mp3");
      $slideshow->addCenteredTextSet(
        [3.956, "You know what you want and don’t let fears,"],
        [2.274, "doubts or bumps in the road stop you from getting it."],
        [NULL, "This will take you far!"]
      );
    }

    if($nameSoMatch)
      $slideshow->addAudio("audio/name-so/so_$fname.mp3");
    $slideshow->addAudio("audio/manifestation/end_1.mp3");
    if($nameSoMatch)
      $slideshow->addAudio("audio/name-so/so_$fname.mp3");
    $slideshow->addAudio("audio/manifestation/end_2.mp3");
    $slideshow->addCenteredTextSet(
      [2.000, "$firstName, that just covers a few of the basics,"],
      [1.700, "based on the responses you just gave in our quiz."],
      [1.499, "But listen..."],
      [2.814, "if you are ready to take the ‘guesswork’ out of the equation,"],
      [3.596, "and start taking the <b>exact steps</b> that lead to success and abundance..."],
      [3.077, "then you NEED to hear what I am about to share with you..."],
      [1.977, "Even if you are struggling right now..."],
      [2.183, "Even if you don’t have what you truly want..."],
      [2.540, "And even if it’s near impossible for you to imagine"],
      [2.710, "living a rich, happy, successful life..."],
      [4.245, "There is <b>one simple key</b> that can make ALL of your dreams happen..."],
      [3.630, "and surprisingly, it doesn’t involve a ton of ‘hard work’..."],
      [4.700, "$firstName, I could literally talk for hours explaining this to you in detail right now..."],
      [3.218, "but because that would not be the best use of your incredibly precious time,"],
      [2.696, "my good friend and colleague, Heather Matthews,"],
      [2.346, "has put together a short video for you instead."],
      [3.540, "So now you can literally see for yourself how it works..."],
      [4.730, "Simply click the link below to discover how to naturally attract all of the prosperity,"],
      [NULL, "love, happiness and abundance that you deserve!"]
    );

    $slideshow->addCallback('showLink');

    $slideshow->addAudio("audio/manifestation/please_click.mp3");
    $slideshow->addCenteredTextSet(
      [NULL, "Please click play on the video below to discover the ultimate secret to manifesting your dream life"]
    );

    $compiledSlideshowPath = $slideshow->compile(true);
    $slideshowid = $slideshow->getID();

  }//check is_array($answers);

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Quiz Results</title>

    <link rel="icon" href="images/favicon.ico" type="image/x-icon">

    <!-- web fonts -->
    <link href='https://fonts.googleapis.com/css?family=Raleway:400,300,500,600,700,200,100|Source+Sans+Pro:400,300,300italic,400italic,600,600italic,700,700italic' rel='stylesheet' type='text/css'>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha.5/css/bootstrap.min.css" />
    <link rel="stylesheet" type="text/css" href="css/quizresults.css" />
    
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.9.2/jquery-ui.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-scrollTo/2.1.2/jquery.scrollTo.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/ouibounce/0.0.12/ouibounce.min.js"></script>
    <script src="js/jquery.jplayer.min.js"></script>
    <script src="js/numerologyslideshow.js"></script>
    
  </head>
  <body>

  <!-- Facebook Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src=v;s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script',
  'https://connect.facebook.net/en_US/fbevents.js');
  fbq('init', '784143738608649');
  fbq('track', 'Lead');
</script>
<noscript><img height="1" width="1" style="display:none"
  src="https://www.facebook.com/tr?id=784143738608649&ev=Lead&noscript=1"
/></noscript>
<!-- End Facebook Pixel Code -->
    <section class="main">
      <section id="quizresults-wrapper">
        <div class="container">
          <div class="row">
            <?php if(is_array($answers)) :?>
            <div class="col-md-12">

              <h3 class="page-subtitle"><?php echo ($firstName) ? $firstName.', ': '';?>this video report has been customized based on your answers...</h3>
              <h3 class="page-title"><?php echo ($firstName) ? $firstName.', ': '';?>you have hit a roadblock on your journey to ultimate life success!</h3>
              <h3 class="page-subtitle-video">Click the play button below to see your personalized results video</h3>

            </div>
          <?php endif;?>
            <div class="col-md-2"></div>
            <div class="col-md-8">
              <?php if(is_array($answers)) :?>
                <div id="slidePlayer">
                  <div id="imgdisplay" class="b">
                    <div id="slidecontent" class="loading"></div>
                  </div>
                </div>
                <div id="sound"></div>
                
                <div id="manifestation-link">
                  <p class="text-center">
                    <a href="https://abundancequiz.com/video.php">
                      <img src="images/monitor.jpg">
                    </a>
                  </p>
                </div><!--#manifestation-link-->
                
                <div id="leave-modal" class="modal">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h4 class="modal-title">WAIT... BEFORE YOU GO!</h4>
                      </div>
                      <div class="modal-body">
                        <p>I wouldn't want you to leave empty handed.</p>
                        <p>Please click play on the video below to discover the ultimate secret to manifesting your dream life</p>
                      </div>
                      <div class="modal-footer">
                        <button id="leave-modal-disable" type="button" class="btn btn-default">No,Thanks</button>
                        <button id="manifestation-link-click" type="button" class="btn btn-default">Play Video</button>
                      </div>
                    </div>
                  </div>
                </div><!--#leave-modal-->
                
              <?php else:?>
                <h3 class="text-center">Sorry, wrong answers passed.</h3>
              <?php endif;?>
            </div><!--/.col-md-8-->
            <div class="col-md-2"></div>
          </div><!--/.row-->
        </div><!--/.container-->
      </section>
    </section>

    
    <?php if(is_array($answers)) :?>
      <script>
          $(function(){
              $show = NumerologySlideshow("#sound","https://storage.googleapis.com/numerologist-888.appspot.com/slides/<?php print $slideshowid;?>/slideshow.json");
          });

          function playPleaseClick(silence){

              $('#sound').jPlayer("setMedia", {
                  title: "Voice",
                  mp3: 'audio/manifestation/please_click_without_silence.mp3'
              }).jPlayer('play');
          }


          function showLink(){
            $('#manifestation-link').slideDown(1000,function(){

              $(window).scrollTo($(this).offset().top-30,{duration: 600});

              var isMobile = (/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Windows Phone/i.test(navigator.userAgent)) ? true : false;
              //if this is desktop browser
              if(!isMobile){

                var modal = ouibounce(document.getElementById('leave-modal'), { aggressive: true , callback: playPleaseClick });
                
                $(document).on('click','#manifestation-link-click',function(event){
                  modal.disable();
                  window.location.href = $('#manifestation-link>p>a').attr('href');
                });

                $(document).on('click','#leave-modal-disable',function(event){
                  modal.disable();
                  $('#leave-modal').fadeOut(function(){
                    $(this).remove();
                  });
                });

              }else{

                window.onunload = window.onbeforeunload = function(event){
                  playPleaseClick();
                  return 'Are you sure you want to leave? Please click play on the video below to discover the ultimate secret to manifesting your dream life.';
                };

              }

            });
          }


      </script>
    <?php endif;?>

  </body>
</html>
