function NumerologySlideshow(jplayerSelector, path) {
    var _player = $("#slidePlayer #slidecontent");
    var _slideID = 0;
    var _this = this;
    var _nexttime = 0;
    var _busy = false;
    var _preloading = [];
    _this.slides = [];

    _this.preload = function () {
        if (_preloading.length == 0) {
            setTimeout(function () {
                _player.removeClass('loading').addClass('paused');
                $(jplayerSelector).jPlayer("play");
            }, 500);
        } else {
            var _i = new Image();
            var url = _preloading.shift();
            _i.onload = function (last) {
                _this.preload();
            }
            _i.src = url;
        }
    };

    _this.drawSlide = function (time) {
        if (!_busy) {
            update = false;
            if (time >= _nexttime) {
                update = true;
            }

            if (update && typeof _this.slides[_slideID] != 'undefined') {
                _busy = true;
                var slide = _this.slides[_slideID];

                if (slide.clear) {
                    _player.empty();
                }

                for (var i = 0; i < slide.items.length; i++) {
                    if (slide.items[i].type == 'callback' && slide.items[i].fn != 'undefined') {
                        if (typeof window[slide.items[i].fn] != 'undefined') {
                            window[slide.items[i].fn].apply(window, slide.items[i].arguments);
                        }
                        continue;
                    }

                    var _el = $(slide.items[i].html);

                    if (typeof slide.items[i].style == 'object') {
                        _el.css(slide.items[i].style);
                    }
                    _el.appendTo(_player);
                };

                _nexttime = _this.slides[_slideID].starttime + _this.slides[_slideID].time;
                _slideID++;
                _busy = false;
            }

        }

    };

    $.getJSON(path, function (data) {
        if (typeof data.style != 'undefined') {
            _player.closest("#imgdisplay").css(data.style);
        }

        if (typeof data.script != 'undefined') {
            $.getScript(data.script);
        }

        _this.slides = data.slides;

        var playtime = 0;
        for (var i = 0; i < _this.slides.length; i++) {
            _this.slides[i].starttime = playtime;
            playtime += _this.slides[i].time;

            for (var j = 0; j < _this.slides[i].items.length; j++) {
                if (_this.slides[i].items[j].type == 'image')
                    _preloading.push(_this.slides[i].items[j].src);
            };


        };

        _this.preload();

        $(jplayerSelector).jPlayer({
            ready: function () {
                $(jplayerSelector).jPlayer("setMedia", {
                    title: "Voice",
                    mp3: data.audio
                });

                $(jplayerSelector).bind(
                    $.jPlayer.event.timeupdate,
                    function (event) {
                        if (!event.jPlayer.status.waitForPlay) {
                            _this.drawSlide(event.jPlayer.status.currentTime);
                        }
                    }
                );
                $("#imgdisplay").bind('click', function (event) {
                    if (!$(jplayerSelector).data().jPlayer.status.paused && !$(jplayerSelector).data().jPlayer.status.ended) {
                        $(jplayerSelector).jPlayer("pause");
                    } else {
                        if(!$(jplayerSelector).data().jPlayer.status.ended)
                            $(jplayerSelector).jPlayer("play");
                    }
                });
            },
            swfPath: "/js",
            preload: 'auto',
            supplied: "mp3",
            play: function () {
                $(_player).removeClass("paused").addClass("played");
            },
            pause: function () {
                $(_player).removeClass("played").addClass("paused");
            },
            ended: function () {
                $(_player).removeClass("played").removeClass("paused");
                $(_player).empty();
                _nexttime = 0;
                _slideID = 0;

                _player.append('<span class="reload"></span>');
            }
        });
    });
};