<?php
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    require_once "classes/autoload.php";
    require_once("classes/Numerology.class.php");


    $firstName  = ucwords( $_REQUEST['inputFirstName'] );
    $dayNum     = (int)$_REQUEST['inputDateDay'];
    $monthNum   = (int)$_REQUEST['inputDateMonth'];
    $yearNum    = (int)$_REQUEST['inputDateYear'];
    $lifePath   = (int)$_REQUEST['inputLifePath'];

    if( !$lifePath )
        $lifePath =  Calculator_Numerology::getLifePathNumber($yearNum, $monthNum, $dayNum);


    $dateObj    = DateTime::createFromFormat('!m', $monthNum);
    $monthName  = $dateObj->format('F'); // January, etc.
    $fname      = strtolower( $firstName );


    $nameMatch  = true; // is the name in our database of audio snippets? Yes for now, while testing...

    $slideshow = new JsSlideshow("images/bg.jpg", 640, 480);

    $slideshow->addAudio("audio/hi-name/hi-$fname.mp3");              // e.g. "Hi Dan,"
    $slideshow->addAudio('audio/lifepath/lifepath-intro-part1.mp3');  // e.g. thanks for requesting your free numerology reading here at numerologist.com. Over the next few minutes, I’m going to give you a quick yet deeply revealing analysis of your unique numerology chart, based on your given name and date of birth.

    $slideshow->addSlide(6); //Add empty slide with 6 sec duration
    $slideshow->setFontSize(30, "pt"); // Default is px, if we ned use other, just pass it in second argument
    $slideshow->setTitle("Numerology Reading\n for <b>$firstName</b>\n Born \n<b><red>$monthName $dayNum, $yearNum</red></b>.");
    $slideshow->addBirthTiles( $yearNum , $monthNum, $dayNum );

    $slideshow->addCenteredTextSet(
        [ 1.3, "Over the next few minutes,"],
        [   3, "I'm going to give you a quick yet <red>deeply revealing</red> analysis"],
        [ 2.1, "of your unique Numerology Chart" ],
        [NULL, "based on your\n<b>given name </b>($firstName)\nand <b>date of birth</b>\n($monthName $dayNum, $yearNum)" ]
        //In the last record we omit the $time argument, this means the slide will be shown until the end of the audio file
    );

    /*
     * If the name is one in our audio database, greet the user by a recording of their name,
     * also noting the length of this recording for sync purposes.
     */
    if ($nameMatch == true ) {
        $f = "audio/name-youhave/".$fname."_youhave.mp3"; // 'you have' is just an indicative pronunciation of the words that might follow the name, and is not in the recording!
        $slideshow->addAudio( $f );
        $nameAudioLength = $slideshow->getAudioLen();
        $there = "$firstName, there";
    }else {
        $nameAudioLength = 0;
        $there = "There";
    }


    $slideshow->addAudio('audio/lifepath/lifepath-intro-part2.mp3'); // {NAME}, there are 5 elements that form the “core” of your chart and that most massively impact your life. etc.
    $slideshow->addCenteredTextSet(
        [3.505 + $nameAudioLength, "$there are\n<b>five elements</b>\nthat form the core of your chart," ],
        [2.396, "and that\n<red>most massively</red>\n<b>impact your life.</b>" ],
        [1.000,  "They are:"]
    );

    $slideshow->clear()->setFontSize(30,'pt')->addSlideBullets(
        [1.18,    "First:\tYour <b>Life Path</b> (test tab)"],
        [1.18,    "Second:\tYour <b>Birthday</b> number"],
        [1.18,    "Your <b>Soul Urge</b>"],
        [ 1.4,    "Your <b>Expression</b>"],
        [1.90,    "Your <b>Personality</b> number"]
    );

    $slideshow->addCenteredTextSet(   // queue a sequence of simple slides, with corresponding timings.
        [2.301, "...and by intimately understanding <b>your</b> numbers" ],
        [2.564, "you'll uncover\nmany fascinating truths..." ],
        [0.922, "about <b>who you are</b>,"],
        [1.395, "how <b>others</b>\nperceive you", ['fontSize'=>'50px','color'=>'red'] ], //Just for test we pass the jquery-like css styles as third argument
        [2.103, "and the <b>unique opportunities</b>\nthat lay ahead" ],
        [4.014, "The most important number in your numerology chart is your <red><b>Life Path</b></red>..." ],
        [4.800, "It reveals your\nmost fulfilling life direction\nand the <red>major lessons</red>\n you’re here to learn… " ],
        [3.730, "it highlights the\n<b>specific opportunities</b> \nand <b>challenges</b> you will encounter," ],
        [3.746, "and your\n<red>unique personality traits</red>\nthat will help you on your journey." ],
        [ NULL, "Your Life Path is calculated\nby simply adding up the digits\nof your <b>date of birth</b>." ]
        //In the last record we omit the $time argument, this means the slide will be shown until the end of the audio file
    );

    $slideshow->addAudio('audio/lifepath/lifepath-'.$lifePath.'-A.mp3');
    $slideshow->clear()->addSlide();
    $slideshow->setTitle("Life Path for <b>$firstName</b>\n Born \n<b><red>$monthName $dayNum, $yearNum</red></b>.");
    $slideshow->addBirthTiles( $yearNum , $monthNum, $dayNum );


    if ($nameMatch == true ){
        $f = "audio/name-youhave/".$fname."_youhave.mp3";
        $slideshow->addAudio( $f );
        $you = "$firstName, you";
    }else{
        $you = "You";
    }

    $slideshow->addAudio('audio/lifepath/lifepath-'.$lifePath.'-B.mp3');
    switch ( $lifePath ) {
        case 1:
            $slideshow->addCenteredTextSet(
                [3.60 + $nameAudioLength,  "$you are a born leader and an absolute authority in your field"],
                [3.667, "Like your Life Path implies, you are destined to be #1."],
                [4.455, "You are ambitious, confident, self-motivated, fiercely independent, "],
                [4.679, "and have a rare talent that is guaranteed to put you in the spotlight at least once in your life."],
                [4.027, "You are very good at getting the ball rolling and initiating new projects, "],
                [3.858, "but tire of routine and highly-detailed tasks quickly."],
                [1.690, "When confronted with obstacles, "],
                [2.584, "your unwavering inner strength and sense of self "],
                [2.902, "acts as a beacon others are inspired to follow."],
                [5.496, "Your assertive nature \nand willingness to do\n“whatever it takes”\nkeeps you ahead of the pack "],
                [2.356, "and is the key\nto your success in life. "],
                [4.674, "While it may often feel like you face more challenges or difficulties in life than others, "],
                [3.217, "it’s only because you’re more ready and able to handle the risk."],
                [3.555, "It’s your job to step up, break away from the status quo, "],
                [1.722, "and inspire those around you. "],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
                );
                break;
        case 2:
            $slideshow->addCenteredTextSet(
                [3.000 + $nameAudioLength, "$you are a sensitive soul with an amazing imagination."],
                [2.644, "You have off-the-charts emotional intelligence,"],
                [2.711, "refined intuition, extreme perceptiveness, "],
                [3.476, "and the ability to truly connect and understand those around you."],
                [2.644, "You’re the world’s best secret-keeper"],
                [2.040, "and your kind and co-operative nature "],
                [2.988, "makes you a fantastic friend, parent, and partner. "],
                [3.394, "While you have the tendency to be a bit of a perfectionist, "],
                [3.164, "it’s only because you sincerely want the best for yourself and others "],
                [2.981, "and see the potential for greatness in everyone you meet."],
                [2.104, "You have the rare gift of persuasion "],
                [2.586, "and can inspire those around you without force. "],
                [2.542, "You’re often accused of being too quiet "],
                [3.508, "but that’s because you spend more time listening than stroking your own ego. "],
                [3.394, "You exhibit a silent yet spiritually-evolved power "],
                [3.458, "that allows you to remain balanced and fair in stressful situations. "],
                [4.949, "You have the innate ability to create harmony, lead with compassion and empathy, "],
                [1.856, "and encourage those around you. "],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 3:
            $slideshow->addCenteredTextSet(
                [3.800 + $nameAudioLength, "$you are chock full of charm, popularity, and wit. "],
                [2.617, "You’re artistic, have unparalleled creativity, "],
                [2.644, "and search for inspiration in everything you do. "],
                [3.499, "You are resilient and willing to step outside your comfort zone "],
                [1.824, "to create the life of your dreams."],
                [4.375, "Your laid back and happy-go-lucky nature makes you very easy to be around. "],
                [3.144, "You’re a warm, generous, and charismatic person… "],
                [3.588, "always willing to inject humor and words of wisdom into any situation. "],
                [3.154, "You’re the life of the party and can always make people laugh. "],
                [4.265, "You believe that life is too short to be wasted in anger or frustration. "],
                [3.216, "While you’re often misjudged as being disorganized "],
                [2.150, "or someone who doesn’t take life seriously enough, "],
                [5.162, "it’s only because you posses an intense desire for joy, personal expression, and adventure "],
                [2.036, "that many people simply don’t understand. "],
                [3.330, "No matter what, continue to share your creative gifts "],
                [2.137, "and passion for life with those around you."],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 4:
            $slideshow->addCenteredTextSet(
                [4.500 + $nameAudioLength, "$you are a natural leader and possess enormous strength, integrity, and discipline."],
                [2.486, "You have a deep understanding of how things work"],
                [4.385, "and the unwavering ability to support yourself and those around you with little effort."],
                [2.499, "Your success in life is not due to luck, "],
                [2.700, "it comes from your honesty and commitment to excellence. "],
                [2.092, "You are reliable, persevering, "],
                [3.521, "and can turn something ordinary into something extraordinary."],
                [2.168, "You’re diligent, organized, "],
                [1.859, "and when it comes to the task at hand, "],
                [1.849, "you get it done no matter what."],
                [1.584, "You are a true survivor "],
                [2.891, "and push through even the biggest obstacles courageously."],
                [2.562, "While you have a tendency to over-work "],
                [1.946, "and can often spread yourself too thin, "],
                [2.350, "it’s only because you’re never willing to give up "],
                [2.238, "and love nothing more than to see results. "],
                [3.350, "You have the rare gift of being able to guide others through adversity "],
                [1.857, "while keeping both feet on the ground. "],
                [NULL, "Do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 5:
            $slideshow->addCenteredTextSet(
                [4.025 + $nameAudioLength, "$you love travel, adventure, variety and meeting new people."],
                [2.519, "You possess the curiosity of a cat "],
                [1.935, "and long to experience life to the fullest. "],
                [3.420, "You make friends easily and your personality is magnetic."],
                [3.028, "Unlike most, you thrive during change "],
                [2.588, "and are not easily ruffled in times of uncertainty. "],
                [3.779, "You love to be involved in \n several different projects \n and activities at once "],
                [2.272, "and are always on the look-out for new adventures. "],
                [3.892, "Your flexibility and adaptability are the keys to your success."],
                [2.700, "You crave freedom above all else "],
                [2.632, "and are willing to do whatever it takes to not be tied down."],
                [4.612, "You’re often accused of being too impulsive, extreme, or a “wild child” "],
                [2.756, "but it’s only because you have such a vibrant free-spirit."],
                [3.135, "You’ve likely experienced more in the past 5 years "],
                [2.435, "than many people have in their entire lifetimes. "],
                [3.587, "You have the rare gift of uplifting and motivating others "],
                [2.655, "through your rich experiences and words of wisdom."],
                [NULL, "Contnue to do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 6:
            $slideshow->addCenteredTextSet(
                [4.443 + $nameAudioLength, "$you are sensitive and empathic with the gift of making everyone around you happy! "],
                [3.801, "You are devoted, certain, and in charge in all ways."],
                [3.925, "Responsibility and service are two of your most important qualities. "],
                [3.027, "You are always looking for ways you can support a greater cause "],
                [2.418, "and have the rare ability to comfort those in need."],
                [4.137, "You are intelligent, creative, and naturally very balanced. "],
                [2.781, "People often seek you out for advice and support "],
                [3.318, "and that’s because you provide profound wisdom without judgment."],
                [3.689, "You are often admired and adored which baffles you. "],
                [0.902, "You are humble, "],
                [2.743, "yet carry a strong sense of pride in everything you do."],
                [2.520, "You have the tendency to put others first "],
                [3.106, "which can leave you feeling drained or taken advantage of at times, "],
                [3.828, "but it’s only because you have such fierce loyalty and commitment to those you love. "],
                [3.576, "Continue to guide and support others while loving yourself too "],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 7:
            $slideshow->addCenteredTextSet(
                [2.542 + $nameAudioLength, "$you are mystical, intuitive, and sensitive. "],
                [4.253, "You have a quiet power and garner the utmost respect from those around you. "],
                [3.904, "You have extraordinary wisdom, like you’ve lived a thousand lifetimes, "],
                [3.678, "and seek enlightenment over material achievement."],
                [2.734, "You have a clear and compelling sense of self "],
                [2.352, "and a deep yearning to understand the unknown. "],
                [1.675, "You’re a analytical thinker, "],
                [1.834, "capable of great concentration,"],
                [2.440, "and give practical insight and advice."],
                [3.037, "You enjoy your privacy and prefer to work alone "],
                [4.181, "but have great confidence, wit, and charm which draws people to you. "],
                [1.669, "You’re often the story-teller, "],
                [2.970, "sharing your sage-like wisdom with those around you.  "],
                [3.026, "At times, you’re accused of being a lone wolf, "],
                [2.193, "someone who lives by their own ideas and methods, "],
                [3.026, "but it’s only because you are fascinated by life’s little mysteries  "],
                [2.283, "and are constantly seeking answers."],
                [2.621, "You have the rare gift of using creative insight"],
                [2.047, "to solve even the trickiest problems."],
                [NULL, "Contnue to do this, and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 8:
            $slideshow->addCenteredTextSet(
                [2.126 + $nameAudioLength, "$you are a take-charge \n kind of person."],
                [2.958, "You’re passionate, tough, \n and have tremendous \n inner strength. "],
                [3.003, "You are a born leader and\n  have outstanding charisma"],
                [1.935, "that inspires others \n to take action."],
                [4.466, "Your great judge of character aids you well in attracting the right people to you."],
                [2.575, "Everything you do \n is larger than life. "],
                [1.574, "You are a true visionary "],
                [2.812, "and do whatever it takes to achieve your lofty goals. "],
                [2.030, "You’re willing to take big risks, "],
                [4.548, "and because of that you’re more likely than most to achieve immeasurable rewards. "],
                [2.207, "When you do \n experience a challenge,"],
                [2.183, "you have the guts and resilience to push forward."],
                [2.114, "You’re a true survivor. "],
                [4.421, "While you are often accused of being stubborn, impatient, or anti-authority, "],
                [3.262, "it’s only because you’re more courageous and determined than most "],
                [2.756, "and don’t like \n getting caught up in the \n “little things”. "],
                [2.081, "Keep focused on \n your grand vision "],
                [1.946, "while patiently guiding those around you "],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\n Life Path potential. "]
            );
            break;
        case 9:
            $slideshow->addCenteredTextSet(
                [1.416 + $nameAudioLength, "$you are an <b>old soul</b>."],
                [1.955, "You are wise \n beyond your years "],
                [3.478, "and posses deep \n intelligence, intuition, \n and psychic ability. "],
                [1.957, "You have a great \n sense of <red>knowingness</red>"],
                [2.261, "and tend to predict things \n before they happen. "],
                [3.386, "You’re highly sensitive and \n feel a wide range of emotions "],
                [1.800, "and that’s because, as a 9, "],
                [3.105, "you embody the vibrations \n of <red> all the other numbers</red>. "],
                [3.430, "You experience \n the greatest extremes of \n happiness and sorrow,"],
                [2.880, "yet you always <red> bounce back </red> \n and move on quickly."],
                [1.625, "You seek \n <red> knowledge and growth </red>"],
                [2.438, "and have a strong sense \n of <b>mission</b> in life. "],
                [3.293, "People are naturally \n drawn to your warm \n and welcoming nature. "],
                [3.127, "You’re often accused of being \n a bit of a daydreamer, "],
                [3.950, "but that’s because your \n creativity and wild imagination \n never ceases. "],
                [2.136, "When you are \n dedicated to your goals, "],
                [2.278, "you exhibit a \n <red> strong sense of character.</red> "],
                [1.974, "Continue to \n <red> listen to your intuition </red>"],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 11:
            $slideshow->addCenteredTextSet(
                [3.081 + $nameAudioLength, "$you are probably already \n aware of how <b>unique</b> \n your life path is "],
                [4.892, "because this \n <b>numerological vibration</b> \n can have quite <red>extreme</red> \n and <red>exciting</red> effects."],
                [3.084, "In numerology, \n 11 is a <b>Master Number</b>. "],
                [3.375, "You have unmatched <red>intelligence</red>, <red>intuition</red>, "],
                [2.778, "and <red>energy</red> that flows \n through you effortlessly. "],
                [2.149, "You inspire people \n without even trying "],
                [3.678, "and new ideas, answers, \n and opportunities present \n themselves quickly,"],
                [1.631, "and often by surprise."],
                [4.106, "All of this amounts to \n <b>a great capacity</b> for \n invention and creation. "],
                [2.396, "Whether you’re aware \n of it yet or not,"],
                [2.013, "you have <red>deep psychic ability</red>"],
                [1.642, "and a rare connection to spirit. "],
                [3.769, "You are a beacon of light \n which others naturally follow. "],
                [2.025, "Because of this, \n you likely find that "],
                [3.662, "others often request your support, advice, and direction."],
                [1.610, "You tend to be a bit emotional "],
                [2.434, "but it’s only because \n you are so highly charged "],
                [2.463, "and experience such \n rich psychic connections "],
                [3.138, "that it can be hard \n to process all the \n information you receive."],
                [2.925, "Continue to be open\nto divine inspiration "],
                [1.586, "and guide others\nwith your wisdom "],
                [NULL, "and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        case 22:
            $slideshow->addCenteredTextSet(
                [3.184 + $nameAudioLength, "$you are probably already \n aware of how unique \n your life path is "],
                [4.892, "because this \n <b>numerological vibration</b> \n can have quite <red>extreme</red> \n and <red>exciting</red> effects."],
                [3.342, "In numerology,\n22 is a <b>Master Number</b>."],
                [2.902, "You are capable of\nbig, BIG things "],
                [2.946, "and probably find yourself\nworking on projects and tasks "],
                [2.982, "that are huge in scope\nor have mass appeal."],
                [2.519, "You are willing to\nwork hard to\nget the job done "],
                [1.473, "and always crave more."],
                [1.946, "The bigger the job, the better! "],
                [3.015, "You’re a great organizer,\nplanner, mover and shaker "],
                [2.069, "that affects the \nlives of many people. "],
                [2.778, "Your <red>charisma</red> evokes the\ncooperation of others, "],
                [1.338, "you don’t need to force it."],
                [0.968, "Because of this, "],
                [4.521, "you likely find that\nothers frequently request\nyour support, advice and direction."],
                [2.745, "You’re often accused of\nbeing a bit of a <red>workaholic</red> "],
                [3.735, "but it’s only because\nyou have an intense desire\nto <red>grow and expand</red>. "],
                [3.453, "You have the ability\nto turn the <red>ordinary</red>\ninto the <red>exceptional</red> "],
                [1.710, "and keep both feet\non the ground, "],
                [2.475, "no matter how high\nyou rise in life. "],
                [NULL, "Continue to do this and you’ll\n<red>effortlessly achieve</red> your\nfull Life Path potential. "]
            );
            break;
        default:
            throw new exception( "Huh? Unknown life path!");
    }

    $slideshow->addAudio('audio/lifepath/lifepath-outro.mp3');
    $slideshow->addCenteredTextSet(
        [3.375, "Next, let’s look at \nwhat is known as your \n “<b><red>Expression</red></b>”"],
        [3.521, "This is another <red> extremely important </red> element in your numerology chart "],
        [2.542, "as it highlights your\n<b>natural talents</b>\n and <b>abilities</b>,"],
        [2.732, "many you likely \n didn’t know you had. "],
        [2.367, "It is often called the \n “<red><b>Destiny Number</b></red>” "],
        [2.403, "because it reveals a great deal about your <b>potential</b>"],
        [2.329, "and what you’re \n <red>meant to accomplish</red> \n in this lifetime."],
        [3.745, "While your Life Path \n is calculated using your \n <red>date of birth</red>, "],
        [4.995, "your Expression is calculated by analyzing the letters of your <red>FULL <b>name</b> at birth</red>. "],
        [1.991, "Why your <red><b>name</b></red>? "],
        [4.322, "It represents the inheritance of your <red>personal history</red> up to the moment of your birth. "],
        [2.382, "Each letter and \n <red>corresponding number</red>,"],
        [1.214, "like a mosaic, "],
        [4.138, "combine to form the \n complete picture of \n <b> who you are </b> and \n <red>who you’re meant to be</red>. "],
        [4.052, "Your <red> name at birth </red> \n is said to be the \n <b> blueprint of your potential</b>. "],
        [3.836, "To get a free personalized \n <b>Expression reading</b> \n based on your full name, "],
        [ NULL, "please enter it below. "]
    );



    // Call Javascript function on slide shown
    $slideshow->addCallback('showFullNameForm');
    
    //We finish with slideshow content, next compile it

    $compiledSlideshowPath = $slideshow->compile();
    header("Location: demoplayer.html#!".$slideshow->getID()."/$dayNum/$monthNum/$yearNum/$firstName");