<?php

	//Define application root
	define('APP_ROOT', realpath(__DIR__ . DIRECTORY_SEPARATOR . '..'));

	//Autoloader
    spl_autoload_register ('autoload');
    function autoload($className) {
        $fileName = APP_ROOT.DIRECTORY_SEPARATOR.'classes'.DIRECTORY_SEPARATOR.$className . '.class.php';
        if(is_readable($fileName)){
            require $fileName;
        }
    }


    //Simple exit function
    function die404(){
	    header("HTTP/1.0 404 Not Found");
		die('Not Found');    	
    }


 
    //Helper, that adds ordinal suffix
	function addOrdinalNumberSuffix($num) {
		if (!in_array(($num % 100),array(11,12,13))){
		  switch ($num % 10) {
		    // Handle 1st, 2nd, 3rd
		    case 1:  return $num.'st';
		    case 2:  return $num.'nd';
		    case 3:  return $num.'rd';
		  }
		}
		return $num.'th';
	}


    if(!isset($_GET['url'])){
		die404();
    }else{
    	//Parse url parts
    	if(preg_match("!^(?:nametiles|birthdate)-([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})-([a-zA-Z]*)-([a-zA-Z\_]*)\.png$!", trim($_GET['url']), $parts)){
    		//If file already exists
    		if(file_exists("./cache/".trim($_GET['url']))){
			    header("Content-type: image/png");
			    print file_get_contents("./cache/".trim($_GET['url']));
			    exit;
    		}else{
    			//If not, pass parsed params to GET global
	    		$months = array("","January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "Novemeber", "December");
	    		if($parts && count($parts)>5){
                    $_GET['y'] = $parts[1];
	    			$_GET['m'] = $months[(int)$parts[2]];
	    			$_GET['d'] = addOrdinalNumberSuffix((int)$parts[3]);
	    			$_GET['firstname'] = str_replace("_", " ", $parts[4]);
	    			$_GET['fullname'] = str_replace("_", " ", $parts[5]);
	    		}else{
					die404();
	    		}
    		}
    	}else{
    		die404();
    	}
    }



     //Create new slide
    $slide = new SimpleSlide(APP_ROOT."/images/bg.jpg", 640, 480);
    $slide->fontsDirectory = APP_ROOT."/fonts";
    $slide->tilesImagesDir = APP_ROOT."/images";
    $slide->fontSize = 28;

    //Add some data to slide
    $slide->setTitle("Personality Profile for\n<b>".$_GET['fullname']."</b>\nBorn ".$_GET['m']." ".$_GET['d'].", ".$_GET['y']);
    
    if( strpos($_GET['url'], 'nametiles') !== false ) {
        $slide->addTiles($_GET['fullname'], 55  );
        //Add play button image to slide
        $slide->addImage("play.png");    
    } else if(strpos($_GET['url'], 'birthdate') !== false){
        $slide->addBirthTiles($parts[1].''.$parts[2].''.$parts[3]);
        $slide->addImage("play.png");
    }

    //Save slide to cache folder
    $slide->saveSlide(trim($_GET['url']), "./cache", TRUE);
    
    //Output image
    header("Content-type: image/png");
    print file_get_contents("./cache/".trim($_GET['url']));
    exit;


    

    
?>